/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight;

import com.nexmo.client.insight.BaseInsightRequest;

public class AdvancedInsightRequest
extends BaseInsightRequest {
    private AdvancedInsightRequest(Builder builder) {
        this.number = builder.number;
        this.country = builder.country;
        this.cnam = builder.cnam;
        this.ipAddress = builder.ipAddress;
    }

    public static Builder builder(String number) {
        return new Builder(number);
    }

    public Boolean getCnam() {
        return this.cnam;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public static AdvancedInsightRequest withNumber(String number) {
        return new Builder(number).build();
    }

    public static AdvancedInsightRequest withNumberAndCountry(String number, String country) {
        return new Builder(number).country(country).build();
    }

    public static class Builder {
        protected String number;
        protected String country;
        protected Boolean cnam;
        protected String ipAddress;

        public Builder(String number) {
            this.number = number;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder cnam(Boolean cnam) {
            this.cnam = cnam;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public AdvancedInsightRequest build() {
            return new AdvancedInsightRequest(this);
        }
    }
}

