/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight;

import com.nexmo.client.AbstractClient;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.insight.AdvancedInsightEndpoint;
import com.nexmo.client.insight.AdvancedInsightRequest;
import com.nexmo.client.insight.AdvancedInsightResponse;
import com.nexmo.client.insight.BasicInsightEndpoint;
import com.nexmo.client.insight.BasicInsightRequest;
import com.nexmo.client.insight.BasicInsightResponse;
import com.nexmo.client.insight.StandardInsightEndpoint;
import com.nexmo.client.insight.StandardInsightRequest;
import com.nexmo.client.insight.StandardInsightResponse;
import java.io.IOException;

public class InsightClient
extends AbstractClient {
    protected BasicInsightEndpoint basic;
    protected StandardInsightEndpoint standard;
    protected AdvancedInsightEndpoint advanced;

    public InsightClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.basic = new BasicInsightEndpoint(httpWrapper);
        this.standard = new StandardInsightEndpoint(httpWrapper);
        this.advanced = new AdvancedInsightEndpoint(httpWrapper);
    }

    public BasicInsightResponse getBasicNumberInsight(String number) throws IOException, NexmoClientException {
        return this.getBasicNumberInsight(BasicInsightRequest.withNumber(number));
    }

    public BasicInsightResponse getBasicNumberInsight(String number, String country) throws IOException, NexmoClientException {
        return this.getBasicNumberInsight(BasicInsightRequest.withNumberAndCountry(number, country));
    }

    public BasicInsightResponse getBasicNumberInsight(BasicInsightRequest basicInsightRequest) throws IOException, NexmoClientException {
        return (BasicInsightResponse)this.basic.execute(basicInsightRequest);
    }

    public StandardInsightResponse getStandardNumberInsight(String number) throws IOException, NexmoClientException {
        return this.getStandardNumberInsight(StandardInsightRequest.withNumber(number));
    }

    public StandardInsightResponse getStandardNumberInsight(String number, String country) throws IOException, NexmoClientException {
        return this.getStandardNumberInsight(StandardInsightRequest.withNumberAndCountry(number, country));
    }

    @Deprecated
    public StandardInsightResponse getStandardNumberInsight(String number, String country, boolean cnam) throws IOException, NexmoClientException {
        return this.getStandardNumberInsight(StandardInsightRequest.builder(number).country(country).cnam(cnam).build());
    }

    public StandardInsightResponse getStandardNumberInsight(StandardInsightRequest standardInsightRequest) throws IOException, NexmoClientException {
        return (StandardInsightResponse)this.standard.execute(standardInsightRequest);
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number) throws IOException, NexmoClientException {
        return this.getAdvancedNumberInsight(AdvancedInsightRequest.withNumber(number));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number, String country) throws IOException, NexmoClientException {
        return this.getAdvancedNumberInsight(AdvancedInsightRequest.withNumberAndCountry(number, country));
    }

    @Deprecated
    public AdvancedInsightResponse getAdvancedNumberInsight(String number, String country, String ipAddress) throws IOException, NexmoClientException {
        return this.getAdvancedNumberInsight(AdvancedInsightRequest.builder(number).country(country).ipAddress(ipAddress).build());
    }

    @Deprecated
    public AdvancedInsightResponse getAdvancedNumberInsight(String number, String country, String ipAddress, boolean cnam) throws IOException, NexmoClientException {
        return this.getAdvancedNumberInsight(AdvancedInsightRequest.builder(number).country(country).ipAddress(ipAddress).cnam(cnam).build());
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(AdvancedInsightRequest advancedInsightRequest) throws IOException, NexmoClientException {
        return (AdvancedInsightResponse)this.advanced.execute(advancedInsightRequest);
    }
}

