/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.numbers;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.numbers.ListNumbersFilter;
import com.nexmo.client.numbers.ListNumbersResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class ListNumbersEndpoint
extends AbstractMethod<ListNumbersFilter, ListNumbersResponse> {
    private static final String PATH = "/account/numbers";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};

    ListNumbersEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(ListNumbersFilter request) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(this.httpWrapper.getHttpConfig().getRestBaseUri() + PATH);
        request.addParams(requestBuilder);
        return requestBuilder;
    }

    @Override
    public ListNumbersResponse parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return ListNumbersResponse.fromJson(json);
    }

    ListNumbersResponse listNumbers(ListNumbersFilter request) throws IOException, NexmoClientException {
        return (ListNumbersResponse)this.execute(request);
    }
}

