/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.numbers;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.numbers.BuyNumberEndpoint;
import com.nexmo.client.numbers.BuyNumberRequest;
import com.nexmo.client.numbers.CancelNumberEndpoint;
import com.nexmo.client.numbers.CancelNumberRequest;
import com.nexmo.client.numbers.ListNumbersEndpoint;
import com.nexmo.client.numbers.ListNumbersFilter;
import com.nexmo.client.numbers.ListNumbersResponse;
import com.nexmo.client.numbers.SearchNumbersEndpoint;
import com.nexmo.client.numbers.SearchNumbersFilter;
import com.nexmo.client.numbers.SearchNumbersResponse;
import com.nexmo.client.numbers.UpdateNumberEndpoint;
import com.nexmo.client.numbers.UpdateNumberRequest;
import java.io.IOException;

public class NumbersClient {
    private ListNumbersEndpoint listNumbers;
    private SearchNumbersEndpoint searchNumbers;
    private CancelNumberEndpoint cancelNumber;
    private BuyNumberEndpoint buyNumber;
    private UpdateNumberEndpoint updateNumber;

    public NumbersClient(HttpWrapper httpWrapper) {
        this.listNumbers = new ListNumbersEndpoint(httpWrapper);
        this.searchNumbers = new SearchNumbersEndpoint(httpWrapper);
        this.cancelNumber = new CancelNumberEndpoint(httpWrapper);
        this.buyNumber = new BuyNumberEndpoint(httpWrapper);
        this.updateNumber = new UpdateNumberEndpoint(httpWrapper);
    }

    public ListNumbersResponse listNumbers() throws IOException, NexmoClientException {
        return this.listNumbers.listNumbers(new ListNumbersFilter());
    }

    public ListNumbersResponse listNumbers(ListNumbersFilter filter) throws IOException, NexmoClientException {
        return this.listNumbers.listNumbers(filter);
    }

    public SearchNumbersResponse searchNumbers(String country) throws IOException, NexmoClientException {
        return this.searchNumbers(new SearchNumbersFilter(country));
    }

    public SearchNumbersResponse searchNumbers(SearchNumbersFilter filter) throws IOException, NexmoClientException {
        return this.searchNumbers.searchNumbers(filter);
    }

    public void buyNumber(String country, String msisdn) throws IOException, NexmoClientException {
        this.buyNumber.execute(new BuyNumberRequest(country, msisdn));
    }

    public void cancelNumber(String country, String msisdn) throws IOException, NexmoClientException {
        this.cancelNumber.execute(new CancelNumberRequest(country, msisdn));
    }

    public void updateNumber(UpdateNumberRequest request) throws IOException, NexmoClientException {
        this.updateNumber.execute(request);
    }

    public void linkNumber(String msisdn, String country, String appId) throws IOException, NexmoClientException {
        UpdateNumberRequest request = new UpdateNumberRequest(msisdn, country);
        request.setVoiceCallbackType(UpdateNumberRequest.CallbackType.APP);
        request.setVoiceCallbackValue(appId);
        this.updateNumber(request);
    }
}

