/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.numbers;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.numbers.SearchNumbersFilter;
import com.nexmo.client.numbers.SearchNumbersResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class SearchNumbersEndpoint
extends AbstractMethod<SearchNumbersFilter, SearchNumbersResponse> {
    private static final String PATH = "/number/search";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};

    SearchNumbersEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SearchNumbersFilter request) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(this.httpWrapper.getHttpConfig().getRestBaseUri() + PATH);
        request.addParams(requestBuilder);
        return requestBuilder;
    }

    @Override
    public SearchNumbersResponse parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return SearchNumbersResponse.fromJson(json);
    }

    SearchNumbersResponse searchNumbers(SearchNumbersFilter request) throws IOException, NexmoClientException {
        return (SearchNumbersResponse)this.execute(request);
    }
}

