/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.verify.CheckRequest;
import com.nexmo.client.verify.CheckResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class CheckMethod
extends AbstractMethod<CheckRequest, CheckResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/verify/check/json";

    CheckMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(CheckRequest request) throws NexmoClientException, UnsupportedEncodingException {
        if (request.getRequestId() == null || request.getCode() == null) {
            throw new IllegalArgumentException("request ID and code parameters are mandatory.");
        }
        RequestBuilder result = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH)).addParameter("request_id", request.getRequestId()).addParameter("code", request.getCode());
        if (request.getIpAddress() != null) {
            result.addParameter("ip_address", request.getIpAddress());
        }
        return result;
    }

    @Override
    public CheckResponse parseResponse(HttpResponse response) throws IOException {
        return CheckResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

