/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.verify.SearchRequest;
import com.nexmo.client.verify.SearchVerifyResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class SearchMethod
extends AbstractMethod<SearchRequest, SearchVerifyResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/verify/search/json";

    SearchMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SearchRequest request) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder result = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH));
        if (request.getRequestIds().length == 1) {
            result.addParameter("request_id", request.getRequestIds()[0]);
        } else {
            for (String requestId : request.getRequestIds()) {
                result.addParameter("request_ids", requestId);
            }
        }
        return result;
    }

    @Override
    public SearchVerifyResponse parseResponse(HttpResponse response) throws IOException {
        return SearchVerifyResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

