/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.ArrayIterator;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.voice.CallInfo;
import com.nexmo.client.voice.EmbeddedCalls;
import com.nexmo.client.voice.PageLinks;
import java.io.IOException;
import java.util.Iterator;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CallInfoPage
implements Iterable<CallInfo> {
    private int count;
    private int pageSize;
    private int recordIndex;
    private PageLinks links;
    private EmbeddedCalls embedded;

    public int getCount() {
        return this.count;
    }

    @JsonProperty(value="page_size")
    public int getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="record_index")
    public int getRecordIndex() {
        return this.recordIndex;
    }

    @JsonProperty(value="_links")
    public PageLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_embedded")
    public EmbeddedCalls getEmbedded() {
        return this.embedded;
    }

    @Override
    public Iterator<CallInfo> iterator() {
        return new ArrayIterator((Object[])this.embedded.getCallInfos());
    }

    public static CallInfoPage fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            return (CallInfoPage)mapper.readValue(json, CallInfoPage.class);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce json from Call object.", jpe);
        }
    }
}

