/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.voice.Call;
import com.nexmo.client.voice.CallEvent;
import com.nexmo.client.voice.CallInfo;
import com.nexmo.client.voice.CallInfoPage;
import com.nexmo.client.voice.CallModifier;
import com.nexmo.client.voice.CallsFilter;
import com.nexmo.client.voice.CreateCallMethod;
import com.nexmo.client.voice.ListCallsMethod;
import com.nexmo.client.voice.ModifyCallMethod;
import com.nexmo.client.voice.ModifyCallResponse;
import com.nexmo.client.voice.ReadCallMethod;
import java.io.IOException;

class CallsEndpoint {
    private final CreateCallMethod createCall;
    private final ReadCallMethod readCall;
    private final ListCallsMethod listCalls;
    private final ModifyCallMethod modifyCall;

    CallsEndpoint(HttpWrapper httpWrapper) {
        this.createCall = new CreateCallMethod(httpWrapper);
        this.readCall = new ReadCallMethod(httpWrapper);
        this.listCalls = new ListCallsMethod(httpWrapper);
        this.modifyCall = new ModifyCallMethod(httpWrapper);
    }

    CallEvent post(Call callRequest) throws IOException, NexmoClientException {
        return (CallEvent)this.createCall.execute(callRequest);
    }

    CallInfoPage get(CallsFilter filter) throws IOException, NexmoClientException {
        return (CallInfoPage)this.listCalls.execute(filter);
    }

    CallInfo get(String uuid) throws IOException, NexmoClientException {
        return (CallInfo)this.readCall.execute(uuid);
    }

    ModifyCallResponse put(CallModifier modifier) throws IOException, NexmoClientException {
        return (ModifyCallResponse)this.modifyCall.execute(modifier);
    }
}

