/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.voice.Call;
import com.nexmo.client.voice.CallEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;

class CreateCallMethod
extends AbstractMethod<Call, CallEvent> {
    private static final Log LOG = LogFactory.getLog(CreateCallMethod.class);
    private static final String PATH = "/calls";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};
    private String uri;

    CreateCallMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    public RequestBuilder makeRequest(Call request) throws NexmoClientException, UnsupportedEncodingException {
        return RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v1") + PATH)).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(request.toJson(), ContentType.APPLICATION_JSON));
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public CallEvent parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return CallEvent.fromJson(json);
    }
}

