/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.voice.CallInfo;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class ReadCallMethod
extends AbstractMethod<String, CallInfo> {
    private static final Log LOG = LogFactory.getLog(ReadCallMethod.class);
    private static final String PATH = "/calls/";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};
    private String baseUri = null;

    ReadCallMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(String callId) {
        return RequestBuilder.get((String)(this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v1") + PATH + callId));
    }

    @Override
    public CallInfo parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return CallInfo.fromJson(json);
    }
}

