/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.voice.TalkResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class StopTalkMethod
extends AbstractMethod<String, TalkResponse> {
    private static final Log LOG = LogFactory.getLog(StopTalkMethod.class);
    private static final String DEFAULT_URI = "https://api.nexmo.com/v1/calls/";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};
    private String uri = "https://api.nexmo.com/v1/calls/";

    StopTalkMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(String uuid) throws NexmoClientException, UnsupportedEncodingException {
        String uri = this.uri + uuid + "/talk";
        return RequestBuilder.delete((String)uri).setHeader("Content-Type", "application/json");
    }

    @Override
    public TalkResponse parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return TalkResponse.fromJson(json);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

