/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.voice.TalkPayload;
import com.nexmo.client.voice.VoiceName;

public class TalkRequest {
    private TalkPayload talkPayload;
    private String uuid;

    public TalkRequest(String uuid, String text, VoiceName voiceName, int loop) {
        this.talkPayload = new TalkPayload(text, voiceName, loop);
        this.uuid = uuid;
    }

    public TalkRequest(String uuid, String text, VoiceName voiceName) {
        this(uuid, text, voiceName, 1);
    }

    public TalkRequest(String uuid, String text, int loop) {
        this(uuid, text, VoiceName.KIMBERLY, loop);
    }

    public TalkRequest(String uuid, String text) {
        this(uuid, text, VoiceName.KIMBERLY, 1);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)this.talkPayload);
        }
        catch (JsonProcessingException jpe) {
            throw new NexmoUnexpectedException("Failed to produce json from TalkRequest object.", jpe);
        }
    }
}

