/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice;

import com.nexmo.client.AbstractClient;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.voice.Call;
import com.nexmo.client.voice.CallEvent;
import com.nexmo.client.voice.CallInfo;
import com.nexmo.client.voice.CallInfoPage;
import com.nexmo.client.voice.CallModifier;
import com.nexmo.client.voice.CallsEndpoint;
import com.nexmo.client.voice.CallsFilter;
import com.nexmo.client.voice.DownloadRecordingEndpoint;
import com.nexmo.client.voice.DtmfEndpoint;
import com.nexmo.client.voice.DtmfResponse;
import com.nexmo.client.voice.ModifyCallAction;
import com.nexmo.client.voice.ModifyCallResponse;
import com.nexmo.client.voice.Recording;
import com.nexmo.client.voice.StreamRequest;
import com.nexmo.client.voice.StreamResponse;
import com.nexmo.client.voice.StreamsEndpoint;
import com.nexmo.client.voice.TalkEndpoint;
import com.nexmo.client.voice.TalkRequest;
import com.nexmo.client.voice.TalkResponse;
import com.nexmo.client.voice.VoiceName;
import java.io.IOException;

public class VoiceClient
extends AbstractClient {
    protected final CallsEndpoint calls;
    protected final StreamsEndpoint streams;
    protected final TalkEndpoint talk;
    protected final DtmfEndpoint dtmf;
    protected final DownloadRecordingEndpoint downloadRecording;

    public VoiceClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.calls = new CallsEndpoint(httpWrapper);
        this.streams = new StreamsEndpoint(httpWrapper);
        this.talk = new TalkEndpoint(httpWrapper);
        this.dtmf = new DtmfEndpoint(httpWrapper);
        this.downloadRecording = new DownloadRecordingEndpoint(httpWrapper);
    }

    public CallEvent createCall(Call callRequest) throws IOException, NexmoClientException {
        return this.calls.post(callRequest);
    }

    public CallInfoPage listCalls() throws IOException, NexmoClientException {
        return this.listCalls(null);
    }

    public CallInfoPage listCalls(CallsFilter filter) throws IOException, NexmoClientException {
        return this.calls.get(filter);
    }

    public CallInfo getCallDetails(String uuid) throws IOException, NexmoClientException {
        return this.calls.get(uuid);
    }

    public DtmfResponse sendDtmf(String uuid, String digits) throws IOException, NexmoClientException {
        return this.dtmf.put(uuid, digits);
    }

    public ModifyCallResponse modifyCall(String uuid, ModifyCallAction action) throws IOException, NexmoClientException {
        return this.modifyCall(new CallModifier(uuid, action));
    }

    public ModifyCallResponse modifyCall(CallModifier modifier) throws IOException, NexmoClientException {
        return this.calls.put(modifier);
    }

    public ModifyCallResponse transferCall(String uuid, String nccoUrl) throws IOException, NexmoClientException {
        return this.modifyCall(CallModifier.transferCall(uuid, nccoUrl));
    }

    public StreamResponse startStream(String uuid, String streamUrl, int loop) throws IOException, NexmoClientException {
        return this.streams.put(new StreamRequest(uuid, streamUrl, loop));
    }

    public StreamResponse startStream(String uuid, String streamUrl) throws IOException, NexmoClientException {
        return this.streams.put(new StreamRequest(uuid, streamUrl, 1));
    }

    public StreamResponse stopStream(String uuid) throws IOException, NexmoClientException {
        return this.streams.delete(uuid);
    }

    public TalkResponse startTalk(String uuid, String text) throws IOException, NexmoClientException {
        return this.talk.put(new TalkRequest(uuid, text));
    }

    public TalkResponse startTalk(String uuid, String text, VoiceName voiceName) throws IOException, NexmoClientException {
        return this.talk.put(new TalkRequest(uuid, text, voiceName));
    }

    public TalkResponse startTalk(String uuid, String text, int loop) throws IOException, NexmoClientException {
        return this.talk.put(new TalkRequest(uuid, text, loop));
    }

    public TalkResponse startTalk(String uuid, String text, VoiceName voiceName, int loop) throws IOException, NexmoClientException {
        return this.talk.put(new TalkRequest(uuid, text, voiceName, loop));
    }

    public TalkResponse stopTalk(String uuid) throws IOException, NexmoClientException {
        return this.talk.delete(uuid);
    }

    public Recording downloadRecording(String recordingUrl) throws IOException, NexmoClientException {
        return (Recording)this.downloadRecording.execute(recordingUrl);
    }
}

