/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.nexmo.client.voice.ncco.Endpoint;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PhoneEndpoint
implements Endpoint {
    private static final String TYPE = "phone";
    private String number;
    private String dtmfAnswer;
    private OnAnswer onAnswer;

    private PhoneEndpoint(Builder builder) {
        this.number = builder.number;
        this.dtmfAnswer = builder.dtmfAnswer;
        this.onAnswer = builder.onAnswer != null ? new OnAnswer(builder.onAnswer) : null;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDtmfAnswer() {
        return this.dtmfAnswer;
    }

    public OnAnswer getOnAnswer() {
        return this.onAnswer;
    }

    public static Builder builder(String number) {
        return new Builder(number);
    }

    private class OnAnswer {
        private String url;

        private OnAnswer(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class Builder {
        private String number;
        private String dtmfAnswer = null;
        private String onAnswer = null;

        public Builder(String number) {
            this.number = number;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder dtmfAnswer(String dtmfAnswer) {
            this.dtmfAnswer = dtmfAnswer;
            return this;
        }

        public Builder onAnswer(String onAnswer) {
            this.onAnswer = onAnswer;
            return this;
        }

        public PhoneEndpoint build() {
            return new PhoneEndpoint(this);
        }
    }
}

