/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeMemoryCache
implements MemoryCache {
    private final MemoryCache cache;
    private final long maxAge;
    private final Map<String, Long> loadingDates = Collections.synchronizedMap(new HashMap());

    public LimitedAgeMemoryCache(MemoryCache cache, long maxAge) {
        this.cache = cache;
        this.maxAge = maxAge * 1000L;
    }

    @Override
    public boolean put(String key, Bitmap value) {
        boolean putSuccesfully = this.cache.put(key, value);
        if (putSuccesfully) {
            this.loadingDates.put(key, System.currentTimeMillis());
        }
        return putSuccesfully;
    }

    @Override
    public Bitmap get(String key) {
        Long loadingDate = this.loadingDates.get(key);
        if (loadingDate != null && System.currentTimeMillis() - loadingDate > this.maxAge) {
            this.cache.remove(key);
            this.loadingDates.remove(key);
        }
        return (Bitmap)this.cache.get(key);
    }

    @Override
    public Bitmap remove(String key) {
        this.loadingDates.remove(key);
        return (Bitmap)this.cache.remove(key);
    }

    @Override
    public Collection<String> keys() {
        return this.cache.keys();
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.loadingDates.clear();
    }
}

