/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.fanarttvapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.omertron.fanarttvapi.FanartTvException;
import com.omertron.fanarttvapi.enumeration.BaseType;
import com.omertron.fanarttvapi.model.FTLatest;
import com.omertron.fanarttvapi.model.FTMovie;
import com.omertron.fanarttvapi.model.FTMusicArtist;
import com.omertron.fanarttvapi.model.FTMusicLabel;
import com.omertron.fanarttvapi.model.FTSeries;
import com.omertron.fanarttvapi.tools.ApiBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.yamj.api.common.exception.ApiExceptionType;
import org.yamj.api.common.http.DigestedResponse;
import org.yamj.api.common.http.DigestedResponseReader;
import org.yamj.api.common.http.SimpleHttpClientBuilder;

public class FanartTvApi {
    private ApiBuilder ftapi;
    private HttpClient httpClient;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final Charset charset = Charset.forName("UTF-8");
    private static ObjectMapper mapper = new ObjectMapper();

    public FanartTvApi(String apiKey) throws FanartTvException {
        this(apiKey, null, (HttpClient)new SimpleHttpClientBuilder().build());
    }

    public FanartTvApi(String apiKey, String clientKey) throws FanartTvException {
        this(apiKey, clientKey, (HttpClient)new SimpleHttpClientBuilder().build());
    }

    public FanartTvApi(String apiKey, String clientKey, HttpClient httpClient) throws FanartTvException {
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new FanartTvException(ApiExceptionType.AUTH_FAILURE, "Invalid API Key");
        }
        this.ftapi = new ApiBuilder(apiKey, clientKey);
        this.httpClient = httpClient;
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public FTSeries getTvArtwork(String id) throws FanartTvException {
        URL url = this.ftapi.getImageUrl(BaseType.TV, id);
        String page = this.requestWebPage(url);
        FTSeries series = null;
        try {
            series = (FTSeries)mapper.readValue(page, FTSeries.class);
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.MAPPING_FAILED, "Failed to get data for ID " + id, url, (Throwable)ex);
        }
        if (series.isError()) {
            throw new FanartTvException(ApiExceptionType.ID_NOT_FOUND, series.getErrorMessage());
        }
        return series;
    }

    public List<FTLatest> getTvLatest(String date) throws FanartTvException {
        URL url = this.ftapi.getLatestUrl(BaseType.TV, date);
        String page = this.requestWebPage(url);
        List latest = null;
        try {
            latest = (List)mapper.readValue(page, (TypeReference)new TypeReference<List<FTLatest>>(){});
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.MAPPING_FAILED, "Failed to get TV Latest with date " + date, url, (Throwable)ex);
        }
        return latest;
    }

    public FTMovie getMovieArtwork(String id) throws FanartTvException {
        URL url = this.ftapi.getImageUrl(BaseType.MOVIE, id);
        String page = this.requestWebPage(url);
        FTMovie movie = null;
        try {
            movie = (FTMovie)mapper.readValue(page, FTMovie.class);
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.MAPPING_FAILED, "Failed to get Movie artwork with ID " + id, url, (Throwable)ex);
        }
        if (movie.isError()) {
            throw new FanartTvException(ApiExceptionType.ID_NOT_FOUND, movie.getErrorMessage());
        }
        return movie;
    }

    public List<FTLatest> getMovieLatest(String date) throws FanartTvException {
        URL url = this.ftapi.getLatestUrl(BaseType.MOVIE, date);
        String page = this.requestWebPage(url);
        List latest = null;
        try {
            latest = (List)mapper.readValue(page, (TypeReference)new TypeReference<List<FTLatest>>(){});
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.MAPPING_FAILED, "Failed to get Movie Latest with date " + date, url, (Throwable)ex);
        }
        return latest;
    }

    public FTMusicArtist getMusicArtist(String id) throws FanartTvException {
        URL url = this.ftapi.getImageUrl(BaseType.ARTIST, id);
        String page = this.requestWebPage(url);
        FTMusicArtist artist = null;
        try {
            artist = (FTMusicArtist)mapper.readValue(page, FTMusicArtist.class);
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.MAPPING_FAILED, "Fauled to get Music Artist with ID " + id, url, (Throwable)ex);
        }
        return artist;
    }

    public FTMusicArtist getMusicAlbum(String id) throws FanartTvException {
        URL url = this.ftapi.getImageUrl(BaseType.ALBUM, id);
        String page = this.requestWebPage(url);
        FTMusicArtist album = null;
        try {
            album = (FTMusicArtist)mapper.readValue(page, FTMusicArtist.class);
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.MAPPING_FAILED, "Failed to get Music Album with ID " + id, url, (Throwable)ex);
        }
        return album;
    }

    public FTMusicLabel getMusicLabel(String id) throws FanartTvException {
        URL url = this.ftapi.getImageUrl(BaseType.LABEL, id);
        String page = this.requestWebPage(url);
        FTMusicLabel label = null;
        try {
            label = (FTMusicLabel)mapper.readValue(page, FTMusicLabel.class);
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.MAPPING_FAILED, "fauled to get Music Label with ID " + id, url, (Throwable)ex);
        }
        return label;
    }

    public List<FTLatest> getMusicArtistLatest(String date) throws FanartTvException {
        URL url = this.ftapi.getLatestUrl(BaseType.ARTIST, date);
        String page = this.requestWebPage(url);
        List latest = null;
        try {
            latest = (List)mapper.readValue(page, (TypeReference)new TypeReference<List<FTLatest>>(){});
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.MAPPING_FAILED, "Failed to get Music Artist Latest with date " + date, url, (Throwable)ex);
        }
        return latest;
    }

    private String requestWebPage(URL url) throws FanartTvException {
        try {
            HttpGet httpGet = new HttpGet(url.toURI());
            httpGet.addHeader("accept", "application/json");
            DigestedResponse response = DigestedResponseReader.requestContent((HttpClient)this.httpClient, (HttpGet)httpGet, (Charset)this.charset);
            if (response.getStatusCode() >= 500) {
                throw new FanartTvException(ApiExceptionType.HTTP_503_ERROR, response.getContent(), response.getStatusCode(), url);
            }
            if (response.getStatusCode() >= 300) {
                throw new FanartTvException(ApiExceptionType.HTTP_404_ERROR, response.getContent(), response.getStatusCode(), url);
            }
            return response.getContent();
        }
        catch (URISyntaxException ex) {
            throw new FanartTvException(ApiExceptionType.CONNECTION_ERROR, "Invalid URL", url, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new FanartTvException(ApiExceptionType.CONNECTION_ERROR, "Error retrieving URL", url, (Throwable)ex);
        }
    }
}

