/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.fanarttvapi.enumeration;

import com.omertron.fanarttvapi.enumeration.FTSourceType;
import org.apache.commons.lang3.StringUtils;

public enum FTArtworkType {
    CLEARART(FTSourceType.TV),
    CLEARLOGO(FTSourceType.TV),
    SEASONTHUMB(FTSourceType.TV),
    TVTHUMB(FTSourceType.TV),
    CHARACTERART(FTSourceType.TV),
    SHOWBACKGROUND(FTSourceType.TV),
    HDTVLOGO(FTSourceType.TV),
    HDCLEARART(FTSourceType.TV),
    TVPOSTER(FTSourceType.TV),
    TVBANNER(FTSourceType.TV),
    SEASONPOSTER(FTSourceType.TV),
    SEASONBANNER(FTSourceType.TV),
    MOVIELOGO(FTSourceType.MOVIE),
    MOVIEDISC(FTSourceType.MOVIE),
    MOVIEART(FTSourceType.MOVIE),
    MOVIEBACKGROUND(FTSourceType.MOVIE),
    MOVIETHUMB(FTSourceType.MOVIE),
    MOVIEBANNER(FTSourceType.MOVIE),
    HDMOVIELOGO(FTSourceType.MOVIE),
    HDMOVIECLEARART(FTSourceType.MOVIE),
    MOVIEPOSTER(FTSourceType.MOVIE),
    CDART(FTSourceType.MUSIC),
    ARTISTBACKGROUND(FTSourceType.MUSIC),
    ALBUMCOVER(FTSourceType.MUSIC),
    MUSICLOGO(FTSourceType.MUSIC),
    ARTISTTHUMB(FTSourceType.MUSIC),
    HDMUSICLOGO(FTSourceType.MUSIC),
    MUSICBANNER(FTSourceType.MUSIC);

    private final FTSourceType sourceType;

    private FTArtworkType(FTSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public FTSourceType getSourceType() {
        return this.sourceType;
    }

    public FTSourceType source() {
        return this.getSourceType();
    }

    public static FTArtworkType fromString(String artworkType) {
        if (StringUtils.isNotBlank((CharSequence)artworkType)) {
            try {
                return FTArtworkType.valueOf(artworkType.trim().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("FTArtworkType " + artworkType + " does not exist.", ex);
            }
        }
        throw new IllegalArgumentException("FTArtworkType must not be null");
    }
}

