/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.fanarttvapi.model;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.omertron.fanarttvapi.enumeration.FTArtworkType;
import com.omertron.fanarttvapi.model.AbstractJsonMapping;
import com.omertron.fanarttvapi.model.FTArtwork;
import com.omertron.fanarttvapi.model.IArtworkList;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class ArtworkList
extends AbstractJsonMapping
implements IArtworkList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<FTArtworkType, List<FTArtwork>> artwork = new EnumMap<FTArtworkType, List<FTArtwork>>(FTArtworkType.class);

    public void addArtwork(FTArtworkType artworkType, List<FTArtwork> artworkList) {
        this.artwork.put(artworkType, artworkList);
    }

    @Override
    public Map<FTArtworkType, List<FTArtwork>> getArtwork() {
        return this.artwork;
    }

    @Override
    public List<FTArtwork> getArtwork(FTArtworkType artworkType) {
        if (this.artwork.containsKey((Object)artworkType)) {
            return this.artwork.get((Object)artworkType);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasArtwork() {
        for (FTArtworkType at : FTArtworkType.values()) {
            if (!this.hasArtwork(at) || this.artwork.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasArtwork(FTArtworkType artworkType) {
        return this.artwork.containsKey((Object)artworkType) && !this.artwork.get((Object)artworkType).isEmpty();
    }

    @JsonSetter(value="artistbackground")
    public void setArtistBackground(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.ARTISTBACKGROUND, ftArtwork);
    }

    @JsonSetter(value="albumcover")
    public void setAlbumCover(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.ALBUMCOVER, ftArtwork);
    }

    @JsonSetter(value="musiclogo")
    public void setMusiclogo(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MUSICLOGO, ftArtwork);
    }

    @JsonSetter(value="hdmusiclogo")
    public void setHdMusicLogo(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.HDMUSICLOGO, ftArtwork);
    }

    @JsonSetter(value="cdart")
    public void setCdArt(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.CDART, ftArtwork);
    }

    @JsonSetter(value="artistthumb")
    public void setArtistThumb(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.ARTISTTHUMB, ftArtwork);
    }

    @JsonSetter(value="musicbanner")
    public void setMusicBanner(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MUSICBANNER, ftArtwork);
    }

    @JsonSetter(value="clearart")
    public void setClearArt(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.CLEARART, ftArtwork);
    }

    @JsonSetter(value="clearlogo")
    public void setClearLogo(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.CLEARLOGO, ftArtwork);
    }

    @JsonSetter(value="seasonthumb")
    public void setSeasonThumb(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.SEASONTHUMB, ftArtwork);
    }

    @JsonSetter(value="tvthumb")
    public void setTvThumb(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.TVTHUMB, ftArtwork);
    }

    @JsonSetter(value="characterart")
    public void setCharacterArt(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.CHARACTERART, ftArtwork);
    }

    @JsonSetter(value="showbackground")
    public void setShowBackground(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.SHOWBACKGROUND, ftArtwork);
    }

    @JsonSetter(value="hdclearart")
    public void setHdClearArt(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.HDCLEARART, ftArtwork);
    }

    @JsonSetter(value="hdtvlogo")
    public void setHdTvLogo(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.HDTVLOGO, ftArtwork);
    }

    @JsonSetter(value="tvbanner")
    public void setTvBanner(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.TVBANNER, ftArtwork);
    }

    @JsonSetter(value="tvposter")
    public void setTvPoster(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.TVPOSTER, ftArtwork);
    }

    @JsonSetter(value="seasonposter")
    public void setSeasonPoster(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.SEASONPOSTER, ftArtwork);
    }

    @JsonSetter(value="seasonbanner")
    public void setSeasonBanner(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.SEASONBANNER, ftArtwork);
    }

    @JsonSetter(value="hdmovielogo")
    public void setHdMovieLogo(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.HDMOVIELOGO, ftArtwork);
    }

    @JsonSetter(value="hdmovieclearart")
    public void setHdMovieClearArt(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.HDMOVIECLEARART, ftArtwork);
    }

    @JsonSetter(value="movielogo")
    public void setMovieLogo(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MOVIELOGO, ftArtwork);
    }

    @JsonSetter(value="moviedisc")
    public void setMovieDisc(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MOVIEDISC, ftArtwork);
    }

    @JsonSetter(value="moviebanner")
    public void setMovieBanner(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MOVIEBANNER, ftArtwork);
    }

    @JsonSetter(value="moviethumb")
    public void setMovieThumb(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MOVIETHUMB, ftArtwork);
    }

    @JsonSetter(value="moviebackground")
    public void setMovieBackground(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MOVIEBACKGROUND, ftArtwork);
    }

    @JsonSetter(value="movieposter")
    public void setMoviePoster(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MOVIEPOSTER, ftArtwork);
    }

    @JsonSetter(value="movieart")
    public void setMovieArt(List<FTArtwork> ftArtwork) {
        this.addArtwork(FTArtworkType.MOVIEART, ftArtwork);
    }
}

