/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.fanarttvapi.tools;

import com.omertron.fanarttvapi.FanartTvException;
import com.omertron.fanarttvapi.enumeration.BaseType;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.exception.ApiExceptionType;

public final class ApiBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ApiBuilder.class);
    private static final String API_BASE = "http://webservice.fanart.tv/v3/";
    private static final String API_TV = "tv/";
    private static final String API_MOVIES = "movies/";
    private static final String API_MUSIC_ARTIST = "music/";
    private static final String API_MUSIC_ALBUMS = "music/albums/";
    private static final String API_MUSIC_LABELS = "music/labels/";
    private static final String API_LATEST = "latest";
    private final String apiKey;
    private final String clientKey;
    private static final String DELIMITER = "?";
    private static final String DELIMITER_APIKEY = "?api_key=";
    private static final String DELIMITER_CLIENT_KEY = "&client_key=";
    private static final String FAILED_TO_CREATE_URL = "Failed to create URL: {} - {}";

    public ApiBuilder(String apiKey) {
        this.apiKey = apiKey;
        this.clientKey = null;
    }

    public ApiBuilder(String apiKey, String clientKey) {
        this.apiKey = apiKey;
        this.clientKey = clientKey;
    }

    private StringBuilder getBaseUrl(BaseType baseType) {
        StringBuilder url = new StringBuilder(API_BASE);
        if (baseType == BaseType.TV) {
            url.append(API_TV);
        } else if (baseType == BaseType.MOVIE) {
            url.append(API_MOVIES);
        } else if (baseType == BaseType.ALBUM) {
            url.append(API_MUSIC_ALBUMS);
        } else if (baseType == BaseType.ARTIST) {
            url.append(API_MUSIC_ARTIST);
        } else if (baseType == BaseType.LABEL) {
            url.append(API_MUSIC_LABELS);
        }
        return url;
    }

    public URL getImageUrl(BaseType baseType, String id) throws FanartTvException {
        StringBuilder url = this.getBaseUrl(baseType);
        url.append(id);
        url.append(DELIMITER_APIKEY).append(this.apiKey);
        if (StringUtils.isNotBlank((CharSequence)this.clientKey)) {
            url.append(DELIMITER_CLIENT_KEY).append(this.clientKey);
        }
        return this.convertUrl(url);
    }

    public URL getLatestUrl(BaseType baseType, String date) throws FanartTvException {
        StringBuilder url = this.getBaseUrl(baseType);
        url.append(API_LATEST);
        url.append(DELIMITER_APIKEY).append(this.apiKey);
        if (StringUtils.isNotBlank((CharSequence)this.clientKey)) {
            url.append(DELIMITER_CLIENT_KEY).append(this.clientKey);
        }
        url.append(DELIMITER).append(date);
        return this.convertUrl(url);
    }

    private URL convertUrl(StringBuilder searchUrl) throws FanartTvException {
        try {
            LOG.trace("URL: {}", (Object)searchUrl.toString());
            return new URL(searchUrl.toString());
        }
        catch (MalformedURLException ex) {
            LOG.warn(FAILED_TO_CREATE_URL, (Object)searchUrl.toString(), (Object)ex.toString());
            throw new FanartTvException(ApiExceptionType.INVALID_URL, "Unable to conver String to URL", 0, searchUrl.toString(), (Throwable)ex);
        }
    }
}

