/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi;

import com.omertron.themoviedbapi.model.movie.MovieInfo;
import org.apache.commons.lang3.StringUtils;

public class Compare {
    private static final int YEAR_LENGTH = 4;

    private Compare() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean movies(MovieInfo moviedb, String title, String year) {
        return Compare.movies(moviedb, title, year, 0, true);
    }

    public static boolean movies(MovieInfo moviedb, String title, String year, int maxDistance, boolean caseSensitive) {
        String secondCompareTitle;
        String firstCompareTitle;
        String primaryTitle;
        if (moviedb == null || StringUtils.isBlank((CharSequence)title)) {
            return false;
        }
        if (caseSensitive) {
            primaryTitle = title;
            firstCompareTitle = moviedb.getOriginalTitle();
            secondCompareTitle = moviedb.getTitle();
        } else {
            primaryTitle = title.toLowerCase();
            firstCompareTitle = moviedb.getTitle().toLowerCase();
            secondCompareTitle = moviedb.getOriginalTitle().toLowerCase();
        }
        if (Compare.isValidYear(year) && Compare.isValidYear(moviedb.getReleaseDate())) {
            String movieYear = moviedb.getReleaseDate().substring(0, 4);
            return movieYear.equals(year) && Compare.compareTitles(primaryTitle, firstCompareTitle, secondCompareTitle, maxDistance);
        }
        return Compare.compareTitles(primaryTitle, firstCompareTitle, secondCompareTitle, maxDistance);
    }

    private static boolean compareTitles(String primaryTitle, String firstCompareTitle, String secondCompareTitle, int maxDistance) {
        if (Compare.compareDistance(primaryTitle, firstCompareTitle, maxDistance)) {
            return true;
        }
        return Compare.compareDistance(primaryTitle, secondCompareTitle, maxDistance);
    }

    public static boolean movies(MovieInfo moviedb, String title, String year, int maxDistance) {
        return Compare.movies(moviedb, title, year, maxDistance, true);
    }

    private static boolean compareDistance(String title1, String title2, int distance) {
        return StringUtils.getLevenshteinDistance((CharSequence)title1, (CharSequence)title2) <= distance;
    }

    private static boolean isValidYear(String year) {
        return StringUtils.isNotBlank((CharSequence)year) && !"UNKNOWN".equals(year);
    }
}

