/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.ExternalSource;
import com.omertron.themoviedbapi.enumeration.MediaType;
import com.omertron.themoviedbapi.enumeration.SearchType;
import com.omertron.themoviedbapi.enumeration.SortBy;
import com.omertron.themoviedbapi.methods.TmdbAccount;
import com.omertron.themoviedbapi.methods.TmdbAuthentication;
import com.omertron.themoviedbapi.methods.TmdbCertifications;
import com.omertron.themoviedbapi.methods.TmdbChanges;
import com.omertron.themoviedbapi.methods.TmdbCollections;
import com.omertron.themoviedbapi.methods.TmdbCompanies;
import com.omertron.themoviedbapi.methods.TmdbConfiguration;
import com.omertron.themoviedbapi.methods.TmdbCredits;
import com.omertron.themoviedbapi.methods.TmdbDiscover;
import com.omertron.themoviedbapi.methods.TmdbEpisodes;
import com.omertron.themoviedbapi.methods.TmdbFind;
import com.omertron.themoviedbapi.methods.TmdbGenres;
import com.omertron.themoviedbapi.methods.TmdbKeywords;
import com.omertron.themoviedbapi.methods.TmdbLists;
import com.omertron.themoviedbapi.methods.TmdbMovies;
import com.omertron.themoviedbapi.methods.TmdbNetworks;
import com.omertron.themoviedbapi.methods.TmdbPeople;
import com.omertron.themoviedbapi.methods.TmdbReviews;
import com.omertron.themoviedbapi.methods.TmdbSearch;
import com.omertron.themoviedbapi.methods.TmdbSeasons;
import com.omertron.themoviedbapi.methods.TmdbTV;
import com.omertron.themoviedbapi.model.Certification;
import com.omertron.themoviedbapi.model.FindResults;
import com.omertron.themoviedbapi.model.Genre;
import com.omertron.themoviedbapi.model.StatusCode;
import com.omertron.themoviedbapi.model.account.Account;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.artwork.ArtworkMedia;
import com.omertron.themoviedbapi.model.authentication.TokenAuthorisation;
import com.omertron.themoviedbapi.model.authentication.TokenSession;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.change.ChangeListItem;
import com.omertron.themoviedbapi.model.collection.Collection;
import com.omertron.themoviedbapi.model.collection.CollectionInfo;
import com.omertron.themoviedbapi.model.company.Company;
import com.omertron.themoviedbapi.model.config.Configuration;
import com.omertron.themoviedbapi.model.config.JobDepartment;
import com.omertron.themoviedbapi.model.credits.CreditBasic;
import com.omertron.themoviedbapi.model.credits.CreditMovieBasic;
import com.omertron.themoviedbapi.model.credits.CreditTVBasic;
import com.omertron.themoviedbapi.model.discover.Discover;
import com.omertron.themoviedbapi.model.keyword.Keyword;
import com.omertron.themoviedbapi.model.list.ListItem;
import com.omertron.themoviedbapi.model.list.UserList;
import com.omertron.themoviedbapi.model.media.AlternativeTitle;
import com.omertron.themoviedbapi.model.media.MediaBasic;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.MediaState;
import com.omertron.themoviedbapi.model.media.Translation;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.movie.MovieBasic;
import com.omertron.themoviedbapi.model.movie.MovieInfo;
import com.omertron.themoviedbapi.model.movie.ReleaseInfo;
import com.omertron.themoviedbapi.model.network.Network;
import com.omertron.themoviedbapi.model.person.ContentRating;
import com.omertron.themoviedbapi.model.person.CreditInfo;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.person.PersonCreditList;
import com.omertron.themoviedbapi.model.person.PersonFind;
import com.omertron.themoviedbapi.model.person.PersonInfo;
import com.omertron.themoviedbapi.model.review.Review;
import com.omertron.themoviedbapi.model.tv.TVBasic;
import com.omertron.themoviedbapi.model.tv.TVEpisodeInfo;
import com.omertron.themoviedbapi.model.tv.TVInfo;
import com.omertron.themoviedbapi.model.tv.TVSeasonInfo;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.ResultsMap;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import java.net.URL;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.yamj.api.common.http.SimpleHttpClientBuilder;

public class TheMovieDbApi {
    private HttpTools httpTools;
    private static TmdbAccount tmdbAccount;
    private static TmdbAuthentication tmdbAuth;
    private static TmdbCertifications tmdbCertifications;
    private static TmdbChanges tmdbChanges;
    private static TmdbCollections tmdbCollections;
    private static TmdbCompanies tmdbCompany;
    private static TmdbConfiguration tmdbConfiguration;
    private static TmdbCredits tmdbCredits;
    private static TmdbDiscover tmdbDiscover;
    private static TmdbFind tmdbFind;
    private static TmdbGenres tmdbGenre;
    private static TmdbKeywords tmdbKeywords;
    private static TmdbLists tmdbList;
    private static TmdbMovies tmdbMovies;
    private static TmdbNetworks tmdbNetworks;
    private static TmdbPeople tmdbPeople;
    private static TmdbReviews tmdbReviews;
    private static TmdbSearch tmdbSearch;
    private static TmdbTV tmdbTv;
    private static TmdbSeasons tmdbSeasons;
    private static TmdbEpisodes tmdbEpisodes;

    public TheMovieDbApi(String apiKey) throws MovieDbException {
        this(apiKey, (HttpClient)new SimpleHttpClientBuilder().build());
    }

    public TheMovieDbApi(String apiKey, HttpClient httpClient) throws MovieDbException {
        this.httpTools = new HttpTools(httpClient);
        this.initialise(apiKey, this.httpTools);
    }

    private void initialise(String apiKey, HttpTools httpTools) {
        tmdbAccount = new TmdbAccount(apiKey, httpTools);
        tmdbAuth = new TmdbAuthentication(apiKey, httpTools);
        tmdbCertifications = new TmdbCertifications(apiKey, httpTools);
        tmdbChanges = new TmdbChanges(apiKey, httpTools);
        tmdbCollections = new TmdbCollections(apiKey, httpTools);
        tmdbCompany = new TmdbCompanies(apiKey, httpTools);
        tmdbConfiguration = new TmdbConfiguration(apiKey, httpTools);
        tmdbCredits = new TmdbCredits(apiKey, httpTools);
        tmdbDiscover = new TmdbDiscover(apiKey, httpTools);
        tmdbFind = new TmdbFind(apiKey, httpTools);
        tmdbGenre = new TmdbGenres(apiKey, httpTools);
        tmdbKeywords = new TmdbKeywords(apiKey, httpTools);
        tmdbList = new TmdbLists(apiKey, httpTools);
        tmdbMovies = new TmdbMovies(apiKey, httpTools);
        tmdbNetworks = new TmdbNetworks(apiKey, httpTools);
        tmdbPeople = new TmdbPeople(apiKey, httpTools);
        tmdbReviews = new TmdbReviews(apiKey, httpTools);
        tmdbSearch = new TmdbSearch(apiKey, httpTools);
        tmdbTv = new TmdbTV(apiKey, httpTools);
        tmdbSeasons = new TmdbSeasons(apiKey, httpTools);
        tmdbEpisodes = new TmdbEpisodes(apiKey, httpTools);
    }

    public Account getAccount(String sessionId) throws MovieDbException {
        return tmdbAccount.getAccount(sessionId);
    }

    public ResultList<UserList> getUserLists(String sessionId, int accountId) throws MovieDbException {
        return tmdbAccount.getUserLists(sessionId, accountId);
    }

    public ResultList<MovieBasic> getFavoriteMovies(String sessionId, int accountId) throws MovieDbException {
        return tmdbAccount.getFavoriteMovies(sessionId, accountId);
    }

    public StatusCode modifyFavoriteStatus(String sessionId, int accountId, Integer mediaId, MediaType mediaType, boolean isFavorite) throws MovieDbException {
        return tmdbAccount.modifyFavoriteStatus(sessionId, accountId, mediaType, mediaId, isFavorite);
    }

    public ResultList<MovieBasic> getRatedMovies(String sessionId, int accountId, Integer page, String sortBy, String language) throws MovieDbException {
        return tmdbAccount.getRatedMovies(sessionId, accountId, page, sortBy, language);
    }

    public ResultList<TVBasic> getRatedTV(String sessionId, int accountId, Integer page, String sortBy, String language) throws MovieDbException {
        return tmdbAccount.getRatedTV(sessionId, accountId, page, sortBy, language);
    }

    public ResultList<MovieBasic> getWatchListMovie(String sessionId, int accountId, Integer page, String sortBy, String language) throws MovieDbException {
        return tmdbAccount.getWatchListMovie(sessionId, accountId, page, sortBy, language);
    }

    public ResultList<TVBasic> getWatchListTV(String sessionId, int accountId, Integer page, String sortBy, String language) throws MovieDbException {
        return tmdbAccount.getWatchListTV(sessionId, accountId, page, sortBy, language);
    }

    public StatusCode addToWatchList(String sessionId, int accountId, MediaType mediaType, Integer mediaId) throws MovieDbException {
        return tmdbAccount.modifyWatchList(sessionId, accountId, mediaType, mediaId, true);
    }

    public StatusCode removeFromWatchList(String sessionId, int accountId, MediaType mediaType, Integer mediaId) throws MovieDbException {
        return tmdbAccount.modifyWatchList(sessionId, accountId, mediaType, mediaId, false);
    }

    public ResultList<TVBasic> getFavoriteTv(String sessionId, int accountId) throws MovieDbException {
        return tmdbAccount.getFavoriteTv(sessionId, accountId);
    }

    public ResultList<MovieBasic> getGuestRatedMovies(String guestSessionId, String language, Integer page, SortBy sortBy) throws MovieDbException {
        return tmdbAccount.getGuestRatedMovies(guestSessionId, language, page, sortBy);
    }

    public TokenAuthorisation getAuthorisationToken() throws MovieDbException {
        return tmdbAuth.getAuthorisationToken();
    }

    public TokenSession getSessionToken(TokenAuthorisation token) throws MovieDbException {
        return tmdbAuth.getSessionToken(token);
    }

    public TokenAuthorisation getSessionTokenLogin(TokenAuthorisation token, String username, String password) throws MovieDbException {
        return tmdbAuth.getSessionTokenLogin(token, username, password);
    }

    public TokenSession getGuestSessionToken() throws MovieDbException {
        return tmdbAuth.getGuestSessionToken();
    }

    public ResultsMap<String, List<Certification>> getMoviesCertification() throws MovieDbException {
        return tmdbCertifications.getMoviesCertification();
    }

    public ResultsMap<String, List<Certification>> getTvCertification() throws MovieDbException {
        return tmdbCertifications.getTvCertification();
    }

    public ResultList<ChangeListItem> getMovieChangeList(Integer page, String startDate, String endDate) throws MovieDbException {
        return tmdbChanges.getChangeList(MethodBase.MOVIE, page, startDate, endDate);
    }

    public ResultList<ChangeListItem> getTvChangeList(Integer page, String startDate, String endDate) throws MovieDbException {
        return tmdbChanges.getChangeList(MethodBase.TV, page, startDate, endDate);
    }

    public ResultList<ChangeListItem> getPersonChangeList(Integer page, String startDate, String endDate) throws MovieDbException {
        return tmdbChanges.getChangeList(MethodBase.PERSON, page, startDate, endDate);
    }

    public CollectionInfo getCollectionInfo(int collectionId, String language) throws MovieDbException {
        return tmdbCollections.getCollectionInfo(collectionId, language);
    }

    public ResultList<Artwork> getCollectionImages(int collectionId, String language) throws MovieDbException {
        return tmdbCollections.getCollectionImages(collectionId, language);
    }

    public Company getCompanyInfo(int companyId) throws MovieDbException {
        return tmdbCompany.getCompanyInfo(companyId);
    }

    public ResultList<MovieBasic> getCompanyMovies(int companyId, String language, Integer page) throws MovieDbException {
        return tmdbCompany.getCompanyMovies(companyId, language, page);
    }

    public Configuration getConfiguration() throws MovieDbException {
        return tmdbConfiguration.getConfig();
    }

    public URL createImageUrl(String imagePath, String requiredSize) throws MovieDbException {
        return tmdbConfiguration.getConfig().createImageUrl(imagePath, requiredSize);
    }

    public ResultList<JobDepartment> getJobs() throws MovieDbException {
        return tmdbConfiguration.getJobs();
    }

    public ResultsMap<String, List<String>> getTimezones() throws MovieDbException {
        return tmdbConfiguration.getTimezones();
    }

    public CreditInfo getCreditInfo(String creditId, String language) throws MovieDbException {
        return tmdbCredits.getCreditInfo(creditId, language);
    }

    public ResultList<MovieBasic> getDiscoverMovies(Discover discover) throws MovieDbException {
        return tmdbDiscover.getDiscoverMovies(discover);
    }

    public ResultList<TVBasic> getDiscoverTV(Discover discover) throws MovieDbException {
        return tmdbDiscover.getDiscoverTV(discover);
    }

    public FindResults find(String id, ExternalSource externalSource, String language) throws MovieDbException {
        return tmdbFind.find(id, externalSource, language);
    }

    public ResultList<Genre> getGenreMovieList(String language) throws MovieDbException {
        return tmdbGenre.getGenreMovieList(language);
    }

    public ResultList<Genre> getGenreTVList(String language) throws MovieDbException {
        return tmdbGenre.getGenreTVList(language);
    }

    public ResultList<MovieBasic> getGenreMovies(int genreId, String language, Integer page, Boolean includeAllMovies, Boolean includeAdult) throws MovieDbException {
        return tmdbGenre.getGenreMovies(genreId, language, page, includeAllMovies, includeAdult);
    }

    public Keyword getKeyword(String keywordId) throws MovieDbException {
        return tmdbKeywords.getKeyword(keywordId);
    }

    public ResultList<MovieBasic> getKeywordMovies(String keywordId, String language, Integer page) throws MovieDbException {
        return tmdbKeywords.getKeywordMovies(keywordId, language, page);
    }

    public ListItem<MovieInfo> getList(String listId) throws MovieDbException {
        return tmdbList.getList(listId);
    }

    public String createList(String sessionId, String name, String description) throws MovieDbException {
        return tmdbList.createList(sessionId, name, description);
    }

    public StatusCode deleteList(String sessionId, String listId) throws MovieDbException {
        return tmdbList.deleteList(sessionId, listId);
    }

    public boolean checkItemStatus(String listId, Integer mediaId) throws MovieDbException {
        return tmdbList.checkItemStatus(listId, mediaId);
    }

    public StatusCode addItemToList(String sessionId, String listId, Integer mediaId) throws MovieDbException {
        return tmdbList.addItem(sessionId, listId, mediaId);
    }

    public StatusCode removeItemFromList(String sessionId, String listId, Integer mediaId) throws MovieDbException {
        return tmdbList.removeItem(sessionId, listId, mediaId);
    }

    public MovieInfo getMovieInfo(int movieId, String language, String ... appendToResponse) throws MovieDbException {
        return tmdbMovies.getMovieInfo(movieId, language, appendToResponse);
    }

    public MovieInfo getMovieInfoImdb(String imdbId, String language, String ... appendToResponse) throws MovieDbException {
        return tmdbMovies.getMovieInfoImdb(imdbId, language, appendToResponse);
    }

    public MediaState getMovieAccountState(int movieId, String sessionId) throws MovieDbException {
        return tmdbMovies.getMovieAccountState(movieId, sessionId);
    }

    public ResultList<AlternativeTitle> getMovieAlternativeTitles(int movieId, String country) throws MovieDbException {
        return tmdbMovies.getMovieAlternativeTitles(movieId, country);
    }

    public MediaCreditList getMovieCredits(int movieId) throws MovieDbException {
        return tmdbMovies.getMovieCredits(movieId);
    }

    public ResultList<Artwork> getMovieImages(int movieId, String language) throws MovieDbException {
        return tmdbMovies.getMovieImages(movieId, language);
    }

    public ResultList<Keyword> getMovieKeywords(int movieId) throws MovieDbException {
        return tmdbMovies.getMovieKeywords(movieId);
    }

    public ResultList<ReleaseInfo> getMovieReleaseInfo(int movieId, String language) throws MovieDbException {
        return tmdbMovies.getMovieReleaseInfo(movieId, language);
    }

    public ResultList<Video> getMovieVideos(int movieId, String language) throws MovieDbException {
        return tmdbMovies.getMovieVideos(movieId, language);
    }

    public ResultList<Translation> getMovieTranslations(int movieId) throws MovieDbException {
        return tmdbMovies.getMovieTranslations(movieId);
    }

    public ResultList<MovieInfo> getSimilarMovies(int movieId, Integer page, String language) throws MovieDbException {
        return tmdbMovies.getSimilarMovies(movieId, page, language);
    }

    public ResultList<Review> getMovieReviews(int movieId, Integer page, String language) throws MovieDbException {
        return tmdbMovies.getMovieReviews(movieId, page, language);
    }

    public ResultList<UserList> getMovieLists(int movieId, Integer page, String language) throws MovieDbException {
        return tmdbMovies.getMovieLists(movieId, page, language);
    }

    public ResultList<ChangeKeyItem> getMovieChanges(int movieId, String startDate, String endDate) throws MovieDbException {
        return tmdbMovies.getMovieChanges(movieId, startDate, endDate);
    }

    public StatusCode postMovieRating(int movieId, int rating, String sessionId, String guestSessionId) throws MovieDbException {
        return tmdbMovies.postMovieRating(movieId, rating, sessionId, guestSessionId);
    }

    public MovieInfo getLatestMovie() throws MovieDbException {
        return tmdbMovies.getLatestMovie();
    }

    public ResultList<MovieInfo> getUpcoming(Integer page, String language) throws MovieDbException {
        return tmdbMovies.getUpcoming(page, language);
    }

    public ResultList<MovieInfo> getNowPlayingMovies(Integer page, String language) throws MovieDbException {
        return tmdbMovies.getNowPlayingMovies(page, language);
    }

    public ResultList<MovieInfo> getPopularMovieList(Integer page, String language) throws MovieDbException {
        return tmdbMovies.getPopularMovieList(page, language);
    }

    public ResultList<MovieInfo> getTopRatedMovies(Integer page, String language) throws MovieDbException {
        return tmdbMovies.getTopRatedMovies(page, language);
    }

    public Network getNetworkInfo(int networkId) throws MovieDbException {
        return tmdbNetworks.getNetworkInfo(networkId);
    }

    public PersonInfo getPersonInfo(int personId, String ... appendToResponse) throws MovieDbException {
        return tmdbPeople.getPersonInfo(personId, appendToResponse);
    }

    public PersonCreditList<CreditMovieBasic> getPersonMovieCredits(int personId, String language) throws MovieDbException {
        return tmdbPeople.getPersonMovieCredits(personId, language);
    }

    public PersonCreditList<CreditTVBasic> getPersonTVCredits(int personId, String language) throws MovieDbException {
        return tmdbPeople.getPersonTVCredits(personId, language);
    }

    public PersonCreditList<CreditBasic> getPersonCombinedCredits(int personId, String language) throws MovieDbException {
        return tmdbPeople.getPersonCombinedCredits(personId, language);
    }

    public ExternalID getPersonExternalIds(int personId) throws MovieDbException {
        return tmdbPeople.getPersonExternalIds(personId);
    }

    public ResultList<Artwork> getPersonImages(int personId) throws MovieDbException {
        return tmdbPeople.getPersonImages(personId);
    }

    public ResultList<ArtworkMedia> getPersonTaggedImages(int personId, Integer page, String language) throws MovieDbException {
        return tmdbPeople.getPersonTaggedImages(personId, page, language);
    }

    public ResultList<ChangeKeyItem> getPersonChanges(int personId, String startDate, String endDate) throws MovieDbException {
        return tmdbPeople.getPersonChanges(personId, startDate, endDate);
    }

    public ResultList<PersonFind> getPersonPopular(Integer page) throws MovieDbException {
        return tmdbPeople.getPersonPopular(page);
    }

    public PersonInfo getPersonLatest() throws MovieDbException {
        return tmdbPeople.getPersonLatest();
    }

    public Review getReviews(String reviewId) throws MovieDbException {
        return tmdbReviews.getReview(reviewId);
    }

    public ResultList<Company> searchCompanies(String query, Integer page) throws MovieDbException {
        return tmdbSearch.searchCompanies(query, page);
    }

    public ResultList<Collection> searchCollection(String query, Integer page, String language) throws MovieDbException {
        return tmdbSearch.searchCollection(query, page, language);
    }

    public ResultList<Keyword> searchKeyword(String query, Integer page) throws MovieDbException {
        return tmdbSearch.searchKeyword(query, page);
    }

    public ResultList<UserList> searchList(String query, Integer page, Boolean includeAdult) throws MovieDbException {
        return tmdbSearch.searchList(query, page, includeAdult);
    }

    public ResultList<MovieInfo> searchMovie(String query, Integer page, String language, Boolean includeAdult, Integer searchYear, Integer primaryReleaseYear, SearchType searchType) throws MovieDbException {
        return tmdbSearch.searchMovie(query, page, language, includeAdult, searchYear, primaryReleaseYear, searchType);
    }

    public ResultList<MediaBasic> searchMulti(String query, Integer page, String language, Boolean includeAdult) throws MovieDbException {
        return tmdbSearch.searchMulti(query, page, language, includeAdult);
    }

    public ResultList<PersonFind> searchPeople(String query, Integer page, Boolean includeAdult, SearchType searchType) throws MovieDbException {
        return tmdbSearch.searchPeople(query, page, includeAdult, searchType);
    }

    public ResultList<TVBasic> searchTV(String query, Integer page, String language, Integer firstAirDateYear, SearchType searchType) throws MovieDbException {
        return tmdbSearch.searchTV(query, page, language, firstAirDateYear, searchType);
    }

    public TVInfo getTVInfo(int tvID, String language, String ... appendToResponse) throws MovieDbException {
        return tmdbTv.getTVInfo(tvID, language, appendToResponse);
    }

    public MediaState getTVAccountState(int tvID, String sessionID) throws MovieDbException {
        return tmdbTv.getTVAccountState(tvID, sessionID);
    }

    public ResultList<AlternativeTitle> getTVAlternativeTitles(int tvID) throws MovieDbException {
        return tmdbTv.getTVAlternativeTitles(tvID);
    }

    public ResultList<ChangeKeyItem> getTVChanges(int tvID, String startDate, String endDate) throws MovieDbException {
        return tmdbTv.getTVChanges(tvID, startDate, endDate);
    }

    public ResultList<ContentRating> getTVContentRatings(int tvID) throws MovieDbException {
        return tmdbTv.getTVContentRatings(tvID);
    }

    public MediaCreditList getTVCredits(int tvID, String language) throws MovieDbException {
        return tmdbTv.getTVCredits(tvID, language);
    }

    public ExternalID getTVExternalIDs(int tvID, String language) throws MovieDbException {
        return tmdbTv.getTVExternalIDs(tvID, language);
    }

    public ResultList<Artwork> getTVImages(int tvID, String language, String ... includeImageLanguage) throws MovieDbException {
        return tmdbTv.getTVImages(tvID, language, includeImageLanguage);
    }

    public ResultList<Keyword> getTVKeywords(int tvID) throws MovieDbException {
        return tmdbTv.getTVKeywords(tvID);
    }

    public StatusCode postTVRating(int tvID, int rating, String sessionID, String guestSessionID) throws MovieDbException {
        return tmdbTv.postTVRating(tvID, rating, sessionID, guestSessionID);
    }

    public ResultList<TVInfo> getTVSimilar(int tvID, Integer page, String language) throws MovieDbException {
        return tmdbTv.getTVSimilar(tvID, page, language);
    }

    public ResultList<Translation> getTVTranslations(int tvID) throws MovieDbException {
        return tmdbTv.getTVTranslations(tvID);
    }

    public ResultList<Video> getTVVideos(int tvID, String language) throws MovieDbException {
        return tmdbTv.getTVVideos(tvID, language);
    }

    public TVInfo getLatestTV() throws MovieDbException {
        return tmdbTv.getLatestTV();
    }

    public ResultList<TVInfo> getTVOnTheAir(Integer page, String language) throws MovieDbException {
        return tmdbTv.getTVOnTheAir(page, language);
    }

    public ResultList<TVInfo> getTVAiringToday(Integer page, String language, String timezone) throws MovieDbException {
        return tmdbTv.getTVAiringToday(page, language, timezone);
    }

    public ResultList<TVInfo> getTVTopRated(Integer page, String language) throws MovieDbException {
        return tmdbTv.getTVTopRated(page, language);
    }

    public ResultList<TVInfo> getTVPopular(Integer page, String language) throws MovieDbException {
        return tmdbTv.getTVPopular(page, language);
    }

    public TVSeasonInfo getSeasonInfo(int tvID, int seasonNumber, String language, String ... appendToResponse) throws MovieDbException {
        return tmdbSeasons.getSeasonInfo(tvID, seasonNumber, language, appendToResponse);
    }

    public ResultList<ChangeKeyItem> getSeasonChanges(int tvID, String startDate, String endDate) throws MovieDbException {
        return tmdbSeasons.getSeasonChanges(tvID, startDate, endDate);
    }

    public MediaState getSeasonAccountState(int tvID, String sessionID) throws MovieDbException {
        return tmdbSeasons.getSeasonAccountState(tvID, sessionID);
    }

    public MediaCreditList getSeasonCredits(int tvID, int seasonNumber) throws MovieDbException {
        return tmdbSeasons.getSeasonCredits(tvID, seasonNumber);
    }

    public ExternalID getSeasonExternalID(int tvID, int seasonNumber, String language) throws MovieDbException {
        return tmdbSeasons.getSeasonExternalID(tvID, seasonNumber, language);
    }

    public ResultList<Artwork> getSeasonImages(int tvID, int seasonNumber, String language, String ... includeImageLanguage) throws MovieDbException {
        return tmdbSeasons.getSeasonImages(tvID, seasonNumber, language, includeImageLanguage);
    }

    public ResultList<Video> getSeasonVideos(int tvID, int seasonNumber, String language) throws MovieDbException {
        return tmdbSeasons.getSeasonVideos(tvID, seasonNumber, language);
    }

    public TVEpisodeInfo getEpisodeInfo(int tvID, int seasonNumber, int episodeNumber, String language, String ... appendToResponse) throws MovieDbException {
        return tmdbEpisodes.getEpisodeInfo(tvID, seasonNumber, episodeNumber, language, appendToResponse);
    }

    public ResultList<ChangeKeyItem> getEpisodeChanges(int episodeID, String startDate, String endDate) throws MovieDbException {
        return tmdbEpisodes.getEpisodeChanges(episodeID, startDate, endDate);
    }

    public MediaState getEpisodeAccountState(int tvID, int seasonNumber, int episodeNumber, String sessionID) throws MovieDbException {
        return tmdbEpisodes.getEpisodeAccountState(tvID, seasonNumber, episodeNumber, sessionID);
    }

    public MediaCreditList getEpisodeCredits(int tvID, int seasonNumber, int episodeNumber) throws MovieDbException {
        return tmdbEpisodes.getEpisodeCredits(tvID, seasonNumber, episodeNumber);
    }

    public ExternalID getEpisodeExternalID(int tvID, int seasonNumber, int episodeNumber, String language) throws MovieDbException {
        return tmdbEpisodes.getEpisodeExternalID(tvID, seasonNumber, episodeNumber, language);
    }

    public ResultList<Artwork> getEpisodeImages(int tvID, int seasonNumber, int episodeNumber) throws MovieDbException {
        return tmdbEpisodes.getEpisodeImages(tvID, seasonNumber, episodeNumber);
    }

    public StatusCode postEpisodeRating(int tvID, int seasonNumber, int episodeNumber, int rating, String sessionID, String guestSessionID) throws MovieDbException {
        return tmdbEpisodes.postEpisodeRating(tvID, seasonNumber, episodeNumber, rating, sessionID, guestSessionID);
    }

    public ResultList<Video> getEpisodeVideos(int tvID, int seasonNumber, int episodeNumber, String language) throws MovieDbException {
        return tmdbEpisodes.getEpisodeVideos(tvID, seasonNumber, episodeNumber, language);
    }
}

