/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.enumeration;

import com.omertron.themoviedbapi.interfaces.AppendToResponseMethod;
import org.apache.commons.lang3.StringUtils;

public enum MovieMethod implements AppendToResponseMethod
{
    ALTERNATIVE_TITLES,
    CHANGES,
    CREDITS,
    IMAGES,
    KEYWORDS,
    LISTS,
    RELEASES,
    REVIEWS,
    SIMILAR,
    TRANSLATIONS,
    VIDEOS;


    @Override
    public String getPropertyString() {
        return this.name().toLowerCase();
    }

    public static MovieMethod fromString(String method) {
        if (StringUtils.isNotBlank((CharSequence)method)) {
            try {
                return MovieMethod.valueOf(method.trim().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Method " + method + " does not exist.", ex);
            }
        }
        throw new IllegalArgumentException("Method must not be null");
    }
}

