/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.enumeration;

import com.omertron.themoviedbapi.interfaces.AppendToResponseMethod;
import org.apache.commons.lang3.StringUtils;

public enum PeopleMethod implements AppendToResponseMethod
{
    CHANGES,
    COMBINED_CREDITS,
    EXTERNAL_IDS,
    IMAGES,
    MOVIE_CREDITS,
    TAGGED_IMAGES,
    TV_CREDITS;


    @Override
    public String getPropertyString() {
        return this.name().toLowerCase();
    }

    public static PeopleMethod fromString(String method) {
        if (StringUtils.isNotBlank((CharSequence)method)) {
            try {
                return PeopleMethod.valueOf(method.trim().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Method " + method + " does not exist.", ex);
            }
        }
        throw new IllegalArgumentException("Method must not be null");
    }
}

