/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.enumeration;

import com.omertron.themoviedbapi.interfaces.AppendToResponseMethod;
import org.apache.commons.lang3.StringUtils;

public enum TVMethod implements AppendToResponseMethod
{
    ALTERNATIVE_TITLES,
    CHANGES,
    CONTENT_RATINGS,
    CREDITS,
    EXTERNAL_IDS,
    IMAGES,
    KEYWORDS,
    SIMILAR,
    TRANSLATIONS,
    VIDEOS;


    @Override
    public String getPropertyString() {
        return this.name().toLowerCase();
    }

    public static TVMethod fromString(String method) {
        if (StringUtils.isNotBlank((CharSequence)method)) {
            try {
                return TVMethod.valueOf(method.trim().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Method " + method + " does not exist.", ex);
            }
        }
        throw new IllegalArgumentException("Method must not be null");
    }
}

