/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.model.artwork.ArtworkMedia;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.change.ChangeListItem;
import com.omertron.themoviedbapi.model.collection.Collection;
import com.omertron.themoviedbapi.model.company.Company;
import com.omertron.themoviedbapi.model.keyword.Keyword;
import com.omertron.themoviedbapi.model.list.UserList;
import com.omertron.themoviedbapi.model.media.AlternativeTitle;
import com.omertron.themoviedbapi.model.movie.MovieBasic;
import com.omertron.themoviedbapi.model.movie.MovieInfo;
import com.omertron.themoviedbapi.model.movie.ReleaseDates;
import com.omertron.themoviedbapi.model.person.ContentRating;
import com.omertron.themoviedbapi.model.person.PersonFind;
import com.omertron.themoviedbapi.model.person.PersonInfo;
import com.omertron.themoviedbapi.model.review.Review;
import com.omertron.themoviedbapi.model.tv.TVBasic;
import com.omertron.themoviedbapi.model.tv.TVInfo;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperChanges;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yamj.api.common.exception.ApiExceptionType;

public class AbstractMethod {
    protected final String apiKey;
    protected final HttpTools httpTools;
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Map<Class, TypeReference> TYPE_REFS = new HashMap<Class, TypeReference>();

    public AbstractMethod(String apiKey, HttpTools httpTools) {
        this.apiKey = apiKey;
        this.httpTools = httpTools;
    }

    protected static TypeReference getTypeReference(Class aClass) throws MovieDbException {
        if (TYPE_REFS.containsKey(aClass)) {
            return TYPE_REFS.get(aClass);
        }
        throw new MovieDbException(ApiExceptionType.UNKNOWN_CAUSE, "Class type reference for '" + aClass.getSimpleName() + "' not found!");
    }

    protected <T> List<T> processWrapperList(TypeReference typeRef, URL url, String errorMessageSuffix) throws MovieDbException {
        WrapperGenericList<T> val = this.processWrapper(typeRef, url, errorMessageSuffix);
        return val.getResults();
    }

    protected <T> WrapperGenericList<T> processWrapper(TypeReference typeRef, URL url, String errorMessageSuffix) throws MovieDbException {
        String webpage = this.httpTools.getRequest(url);
        try {
            return (WrapperGenericList)MAPPER.readValue(webpage, typeRef);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get " + errorMessageSuffix, url, (Throwable)ex);
        }
    }

    protected ResultList<ChangeKeyItem> getMediaChanges(int mediaID, String startDate, String endDate) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, mediaID);
        parameters.add(Param.START_DATE, startDate);
        parameters.add(Param.END_DATE, endDate);
        URL url = new ApiUrl(this.apiKey, MethodBase.EPISODE).subMethod(MethodSub.CHANGES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperChanges wrapper = (WrapperChanges)MAPPER.readValue(webpage, WrapperChanges.class);
            ResultList<ChangeKeyItem> results = new ResultList<ChangeKeyItem>(wrapper.getChangedItems());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get changes", url, (Throwable)ex);
        }
    }

    static {
        TYPE_REFS.put(MovieBasic.class, (TypeReference)new TypeReference<WrapperGenericList<MovieBasic>>(){});
        TYPE_REFS.put(TVBasic.class, (TypeReference)new TypeReference<WrapperGenericList<TVBasic>>(){});
        TYPE_REFS.put(UserList.class, (TypeReference)new TypeReference<WrapperGenericList<UserList>>(){});
        TYPE_REFS.put(Company.class, (TypeReference)new TypeReference<WrapperGenericList<Company>>(){});
        TYPE_REFS.put(Collection.class, (TypeReference)new TypeReference<WrapperGenericList<Collection>>(){});
        TYPE_REFS.put(Keyword.class, (TypeReference)new TypeReference<WrapperGenericList<Keyword>>(){});
        TYPE_REFS.put(MovieInfo.class, (TypeReference)new TypeReference<WrapperGenericList<MovieInfo>>(){});
        TYPE_REFS.put(PersonInfo.class, (TypeReference)new TypeReference<WrapperGenericList<PersonInfo>>(){});
        TYPE_REFS.put(PersonFind.class, (TypeReference)new TypeReference<WrapperGenericList<PersonFind>>(){});
        TYPE_REFS.put(Review.class, (TypeReference)new TypeReference<WrapperGenericList<Review>>(){});
        TYPE_REFS.put(ChangeListItem.class, (TypeReference)new TypeReference<WrapperGenericList<ChangeListItem>>(){});
        TYPE_REFS.put(ArtworkMedia.class, (TypeReference)new TypeReference<WrapperGenericList<ArtworkMedia>>(){});
        TYPE_REFS.put(ContentRating.class, (TypeReference)new TypeReference<WrapperGenericList<ContentRating>>(){});
        TYPE_REFS.put(TVInfo.class, (TypeReference)new TypeReference<WrapperGenericList<TVInfo>>(){});
        TYPE_REFS.put(AlternativeTitle.class, (TypeReference)new TypeReference<WrapperGenericList<AlternativeTitle>>(){});
        TYPE_REFS.put(ReleaseDates.class, (TypeReference)new TypeReference<WrapperGenericList<ReleaseDates>>(){});
    }
}

