/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.MediaType;
import com.omertron.themoviedbapi.enumeration.SortBy;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.StatusCode;
import com.omertron.themoviedbapi.model.account.Account;
import com.omertron.themoviedbapi.model.list.UserList;
import com.omertron.themoviedbapi.model.movie.MovieBasic;
import com.omertron.themoviedbapi.model.tv.TVBasic;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.PostBody;
import com.omertron.themoviedbapi.tools.PostTools;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbAccount
extends AbstractMethod {
    public TmdbAccount(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public Account getAccount(String sessionId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (Account)MAPPER.readValue(webpage, Account.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get Account", url, (Throwable)ex);
        }
    }

    public ResultList<UserList> getUserLists(String sessionId, int accountId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.LISTS).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbAccount.getTypeReference(UserList.class), url, "user list");
        return wrapper.getResultsList();
    }

    public ResultList<MovieBasic> getFavoriteMovies(String sessionId, int accountId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.FAVORITE_MOVIES).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbAccount.getTypeReference(MovieBasic.class), url, "favorite movies");
        return wrapper.getResultsList();
    }

    public ResultList<TVBasic> getFavoriteTv(String sessionId, int accountId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.FAVORITE_TV).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbAccount.getTypeReference(TVBasic.class), url, "favorite TV shows");
        return wrapper.getResultsList();
    }

    public StatusCode modifyFavoriteStatus(String sessionId, int accountId, MediaType mediaType, int mediaId, boolean setFavorite) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        String jsonBody = new PostTools().add(PostBody.MEDIA_TYPE, (Object)mediaType.toString().toLowerCase()).add(PostBody.MEDIA_ID, (Object)mediaId).add(PostBody.FAVORITE, (Object)setFavorite).build();
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.FAVORITE).buildUrl(parameters);
        String webpage = this.httpTools.postRequest(url, jsonBody);
        try {
            return (StatusCode)MAPPER.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to set favorite status", url, (Throwable)ex);
        }
    }

    public ResultList<MovieBasic> getRatedMovies(String sessionId, int accountId, Integer page, String sortBy, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.SORT_BY, sortBy);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.RATED_MOVIES).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbAccount.getTypeReference(MovieBasic.class), url, "rated movies");
        return wrapper.getResultsList();
    }

    public ResultList<TVBasic> getRatedTV(String sessionId, int accountId, Integer page, String sortBy, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.SORT_BY, sortBy);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.RATED_TV).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbAccount.getTypeReference(TVBasic.class), url, "rated TV shows");
        return wrapper.getResultsList();
    }

    public ResultList<MovieBasic> getWatchListMovie(String sessionId, int accountId, Integer page, String sortBy, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.SORT_BY, sortBy);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.WATCHLIST_MOVIES).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbAccount.getTypeReference(MovieBasic.class), url, "movie watch list");
        return wrapper.getResultsList();
    }

    public ResultList<TVBasic> getWatchListTV(String sessionId, int accountId, Integer page, String sortBy, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.SORT_BY, sortBy);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.WATCHLIST_TV).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbAccount.getTypeReference(TVBasic.class), url, "TV watch list");
        return wrapper.getResultsList();
    }

    public StatusCode modifyWatchList(String sessionId, int accountId, MediaType mediaType, Integer movieId, boolean addToWatchlist) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, accountId);
        String jsonBody = new PostTools().add(PostBody.MEDIA_TYPE, (Object)mediaType.toString().toLowerCase()).add(PostBody.MEDIA_ID, (Object)movieId).add(PostBody.WATCHLIST, (Object)addToWatchlist).build();
        URL url = new ApiUrl(this.apiKey, MethodBase.ACCOUNT).subMethod(MethodSub.WATCHLIST).buildUrl(parameters);
        String webpage = this.httpTools.postRequest(url, jsonBody);
        try {
            return (StatusCode)MAPPER.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to modify watch list", url, (Throwable)ex);
        }
    }

    public ResultList<MovieBasic> getGuestRatedMovies(String guestSessionId, String language, Integer page, SortBy sortBy) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, guestSessionId);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        if (sortBy != null) {
            parameters.add(Param.SORT_BY, "created_at");
            if (sortBy.getPropertyString().endsWith("asc")) {
                parameters.add(Param.SORT_ORDER, "asc");
            } else {
                parameters.add(Param.SORT_ORDER, "desc");
            }
        }
        URL url = new ApiUrl(this.apiKey, MethodBase.GUEST_SESSION).subMethod(MethodSub.RATED_MOVIES_GUEST).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbAccount.getTypeReference(MovieBasic.class), url, "Guest Session Movies");
        return wrapper.getResultsList();
    }
}

