/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.authentication.TokenAuthorisation;
import com.omertron.themoviedbapi.model.authentication.TokenSession;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbAuthentication
extends AbstractMethod {
    public TmdbAuthentication(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public TokenAuthorisation getAuthorisationToken() throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        URL url = new ApiUrl(this.apiKey, MethodBase.AUTH).subMethod(MethodSub.TOKEN_NEW).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (TokenAuthorisation)MAPPER.readValue(webpage, TokenAuthorisation.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.AUTH_FAILURE, "Failed to get Authorisation Token", url, (Throwable)ex);
        }
    }

    public TokenSession getSessionToken(TokenAuthorisation token) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        if (!token.getSuccess().booleanValue()) {
            throw new MovieDbException(ApiExceptionType.AUTH_FAILURE, "Authorisation token was not successful!");
        }
        parameters.add(Param.TOKEN, token.getRequestToken());
        URL url = new ApiUrl(this.apiKey, MethodBase.AUTH).subMethod(MethodSub.SESSION_NEW).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (TokenSession)MAPPER.readValue(webpage, TokenSession.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get Session Token", url, (Throwable)ex);
        }
    }

    public TokenAuthorisation getSessionTokenLogin(TokenAuthorisation token, String username, String password) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        if (!token.getSuccess().booleanValue()) {
            throw new MovieDbException(ApiExceptionType.AUTH_FAILURE, "Authorisation token was not successful!");
        }
        parameters.add(Param.TOKEN, token.getRequestToken());
        parameters.add(Param.USERNAME, username);
        parameters.add(Param.PASSWORD, password);
        URL url = new ApiUrl(this.apiKey, MethodBase.AUTH).subMethod(MethodSub.TOKEN_VALIDATE).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (TokenAuthorisation)MAPPER.readValue(webpage, TokenAuthorisation.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get Session Token", url, (Throwable)ex);
        }
    }

    public TokenSession getGuestSessionToken() throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.AUTH).subMethod(MethodSub.GUEST_SESSION).buildUrl();
        String webpage = this.httpTools.getRequest(url);
        try {
            return (TokenSession)MAPPER.readValue(webpage, TokenSession.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get Guest Session Token", url, (Throwable)ex);
        }
    }
}

