/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.Certification;
import com.omertron.themoviedbapi.results.ResultsMap;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbCertifications
extends AbstractMethod {
    public TmdbCertifications(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public ResultsMap<String, List<Certification>> getMoviesCertification() throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.CERTIFICATION).subMethod(MethodSub.MOVIE_LIST).buildUrl();
        String webpage = this.httpTools.getRequest(url);
        try {
            JsonNode node = MAPPER.readTree(webpage);
            Map results = (Map)MAPPER.readValue(((JsonNode)node.elements().next()).traverse(), (TypeReference)new TypeReference<Map<String, List<Certification>>>(){});
            return new ResultsMap<String, List<Certification>>(results);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get movie certifications", url, (Throwable)ex);
        }
    }

    public ResultsMap<String, List<Certification>> getTvCertification() throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.CERTIFICATION).subMethod(MethodSub.TV_LIST).buildUrl();
        String webpage = this.httpTools.getRequest(url);
        try {
            JsonNode node = MAPPER.readTree(webpage);
            Map results = (Map)MAPPER.readValue(((JsonNode)node.elements().next()).traverse(), (TypeReference)new TypeReference<Map<String, List<Certification>>>(){});
            return new ResultsMap<String, List<Certification>>(results);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get TV certifications", url, (Throwable)ex);
        }
    }
}

