/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.company.Company;
import com.omertron.themoviedbapi.model.movie.MovieBasic;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbCompanies
extends AbstractMethod {
    public TmdbCompanies(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public Company getCompanyInfo(int companyId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, companyId);
        URL url = new ApiUrl(this.apiKey, MethodBase.COMPANY).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (Company)MAPPER.readValue(webpage, Company.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get company information", url, (Throwable)ex);
        }
    }

    public ResultList<MovieBasic> getCompanyMovies(int companyId, String language, Integer page) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, companyId);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.COMPANY).subMethod(MethodSub.MOVIES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        WrapperGenericList wrapper = this.processWrapper(TmdbCompanies.getTypeReference(MovieBasic.class), url, webpage);
        return wrapper.getResultsList();
    }
}

