/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.fasterxml.jackson.core.type.TypeReference;
import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.config.Configuration;
import com.omertron.themoviedbapi.model.config.JobDepartment;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.ResultsMap;
import com.omertron.themoviedbapi.results.WrapperConfig;
import com.omertron.themoviedbapi.results.WrapperJobList;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbConfiguration
extends AbstractMethod {
    private static Configuration config = null;

    public TmdbConfiguration(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public Configuration getConfig() throws MovieDbException {
        if (config == null) {
            URL configUrl = new ApiUrl(this.apiKey, MethodBase.CONFIGURATION).buildUrl();
            String webpage = this.httpTools.getRequest(configUrl);
            try {
                WrapperConfig wc = (WrapperConfig)MAPPER.readValue(webpage, WrapperConfig.class);
                config = wc.getTmdbConfiguration();
            }
            catch (IOException ex) {
                throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to read configuration", configUrl, (Throwable)ex);
            }
        }
        return config;
    }

    public ResultList<JobDepartment> getJobs() throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.JOB).subMethod(MethodSub.LIST).buildUrl();
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperJobList wrapper = (WrapperJobList)MAPPER.readValue(webpage, WrapperJobList.class);
            ResultList<JobDepartment> results = new ResultList<JobDepartment>(wrapper.getJobs());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get job list", url, (Throwable)ex);
        }
    }

    public ResultsMap<String, List<String>> getTimezones() throws MovieDbException {
        List tzList;
        URL url = new ApiUrl(this.apiKey, MethodBase.TIMEZONES).subMethod(MethodSub.LIST).buildUrl();
        String webpage = this.httpTools.getRequest(url);
        try {
            tzList = (List)MAPPER.readValue(webpage, (TypeReference)new TypeReference<List<Map<String, List<String>>>>(){});
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get timezone list", url, (Throwable)ex);
        }
        ResultsMap<String, List<String>> timezones = new ResultsMap<String, List<String>>();
        for (Map tzMap : tzList) {
            for (Map.Entry x : tzMap.entrySet()) {
                timezones.put((String)x.getKey(), (List<String>)x.getValue());
            }
        }
        return timezones;
    }
}

