/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.person.CreditInfo;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbCredits
extends AbstractMethod {
    public TmdbCredits(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public CreditInfo getCreditInfo(String creditId, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, creditId);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.CREDIT).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (CreditInfo)MAPPER.readValue(webpage, CreditInfo.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get credit info", url, (Throwable)ex);
        }
    }
}

