/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.discover.Discover;
import com.omertron.themoviedbapi.model.movie.MovieBasic;
import com.omertron.themoviedbapi.model.tv.TVBasic;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import java.net.URL;

public class TmdbDiscover
extends AbstractMethod {
    public TmdbDiscover(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public ResultList<MovieBasic> getDiscoverMovies(Discover discover) throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.DISCOVER).subMethod(MethodSub.MOVIE).buildUrl(discover.getParams());
        String webpage = this.httpTools.getRequest(url);
        WrapperGenericList wrapper = this.processWrapper(TmdbDiscover.getTypeReference(MovieBasic.class), url, webpage);
        return wrapper.getResultsList();
    }

    public ResultList<TVBasic> getDiscoverTV(Discover discover) throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.DISCOVER).subMethod(MethodSub.TV).buildUrl(discover.getParams());
        String webpage = this.httpTools.getRequest(url);
        WrapperGenericList wrapper = this.processWrapper(TmdbDiscover.getTypeReference(TVBasic.class), url, webpage);
        return wrapper.getResultsList();
    }
}

