/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.StatusCode;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.MediaState;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.tv.TVEpisodeInfo;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperImages;
import com.omertron.themoviedbapi.results.WrapperVideos;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.PostBody;
import com.omertron.themoviedbapi.tools.PostTools;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbEpisodes
extends AbstractMethod {
    private static final int RATING_MAX = 10;

    public TmdbEpisodes(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public TVEpisodeInfo getEpisodeInfo(int tvID, int seasonNumber, int episodeNumber, String language, String ... appendToResponse) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.EPISODE_NUMBER, episodeNumber);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.APPEND, appendToResponse);
        URL url = new ApiUrl(this.apiKey, MethodBase.EPISODE).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (TVEpisodeInfo)MAPPER.readValue(webpage, TVEpisodeInfo.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get TV Episode Info", url, (Throwable)ex);
        }
    }

    public ResultList<ChangeKeyItem> getEpisodeChanges(int episodeID, String startDate, String endDate) throws MovieDbException {
        return this.getMediaChanges(episodeID, startDate, endDate);
    }

    public MediaState getEpisodeAccountState(int tvID, int seasonNumber, int episodeNumber, String sessionID) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SESSION_ID, sessionID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.EPISODE_NUMBER, episodeNumber);
        URL url = new ApiUrl(this.apiKey, MethodBase.EPISODE).subMethod(MethodSub.ACCOUNT_STATES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MediaState)MAPPER.readValue(webpage, MediaState.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get account state", url, (Throwable)ex);
        }
    }

    public MediaCreditList getEpisodeCredits(int tvID, int seasonNumber, int episodeNumber) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.EPISODE_NUMBER, episodeNumber);
        URL url = new ApiUrl(this.apiKey, MethodBase.EPISODE).subMethod(MethodSub.CREDITS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MediaCreditList)MAPPER.readValue(webpage, MediaCreditList.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get credits", url, (Throwable)ex);
        }
    }

    public ExternalID getEpisodeExternalID(int tvID, int seasonNumber, int episodeNumber, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.EPISODE_NUMBER, episodeNumber);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.EPISODE).subMethod(MethodSub.EXTERNAL_IDS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (ExternalID)MAPPER.readValue(webpage, ExternalID.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get external IDs", url, (Throwable)ex);
        }
    }

    public ResultList<Artwork> getEpisodeImages(int tvID, int seasonNumber, int episodeNumber) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.EPISODE_NUMBER, episodeNumber);
        URL url = new ApiUrl(this.apiKey, MethodBase.EPISODE).subMethod(MethodSub.IMAGES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperImages wrapper = (WrapperImages)MAPPER.readValue(webpage, WrapperImages.class);
            ResultList<Artwork> results = new ResultList<Artwork>(wrapper.getAll(new ArtworkType[0]));
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get images", url, (Throwable)ex);
        }
    }

    public StatusCode postEpisodeRating(int tvID, int seasonNumber, int episodeNumber, int rating, String sessionID, String guestSessionID) throws MovieDbException {
        if (rating < 0 || rating > 10) {
            throw new MovieDbException(ApiExceptionType.UNKNOWN_CAUSE, "Rating out of range");
        }
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.EPISODE_NUMBER, episodeNumber);
        parameters.add(Param.SESSION_ID, sessionID);
        parameters.add(Param.GUEST_SESSION_ID, guestSessionID);
        URL url = new ApiUrl(this.apiKey, MethodBase.EPISODE).subMethod(MethodSub.RATING).buildUrl(parameters);
        String jsonBody = new PostTools().add(PostBody.VALUE, (Object)rating).build();
        String webpage = this.httpTools.postRequest(url, jsonBody);
        try {
            return (StatusCode)MAPPER.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to post rating", url, (Throwable)ex);
        }
    }

    public ResultList<Video> getEpisodeVideos(int tvID, int seasonNumber, int episodeNumber, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.EPISODE_NUMBER, episodeNumber);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.EPISODE).subMethod(MethodSub.VIDEOS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperVideos wrapper = (WrapperVideos)MAPPER.readValue(webpage, WrapperVideos.class);
            ResultList<Video> results = new ResultList<Video>(wrapper.getVideos());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get videos", url, (Throwable)ex);
        }
    }
}

