/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.ExternalSource;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.FindResults;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbFind
extends AbstractMethod {
    public TmdbFind(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public FindResults find(String id, ExternalSource externalSource, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, id);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.EXTERNAL_SOURCE, externalSource.getPropertyString());
        URL url = new ApiUrl(this.apiKey, MethodBase.FIND).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (FindResults)MAPPER.readValue(webpage, FindResults.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get find results", url, (Throwable)ex);
        }
    }
}

