/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.Genre;
import com.omertron.themoviedbapi.model.movie.MovieBasic;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperGenres;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbGenres
extends AbstractMethod {
    public TmdbGenres(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public ResultList<Genre> getGenreMovieList(String language) throws MovieDbException {
        return this.getGenreList(language, MethodSub.MOVIE_LIST);
    }

    public ResultList<Genre> getGenreTVList(String language) throws MovieDbException {
        return this.getGenreList(language, MethodSub.TV_LIST);
    }

    private ResultList<Genre> getGenreList(String language, MethodSub sub) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.GENRE).subMethod(sub).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperGenres wrapper = (WrapperGenres)MAPPER.readValue(webpage, WrapperGenres.class);
            ResultList<Genre> results = new ResultList<Genre>(wrapper.getGenres());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get genre " + sub.toString(), url, (Throwable)ex);
        }
    }

    public ResultList<MovieBasic> getGenreMovies(int genreId, String language, Integer page, Boolean includeAllMovies, Boolean includeAdult) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, genreId);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.INCLUDE_ALL_MOVIES, includeAllMovies);
        parameters.add(Param.INCLUDE_ADULT, includeAdult);
        URL url = new ApiUrl(this.apiKey, MethodBase.GENRE).subMethod(MethodSub.MOVIES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        WrapperGenericList wrapper = this.processWrapper(TmdbGenres.getTypeReference(MovieBasic.class), url, webpage);
        return wrapper.getResultsList();
    }
}

