/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.fasterxml.jackson.core.type.TypeReference;
import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.StatusCode;
import com.omertron.themoviedbapi.model.list.ListItem;
import com.omertron.themoviedbapi.model.list.ListItemStatus;
import com.omertron.themoviedbapi.model.list.ListStatusCode;
import com.omertron.themoviedbapi.model.movie.MovieInfo;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.PostBody;
import com.omertron.themoviedbapi.tools.PostTools;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbLists
extends AbstractMethod {
    public TmdbLists(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public ListItem<MovieInfo> getList(String listId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, listId);
        URL url = new ApiUrl(this.apiKey, MethodBase.LIST).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (ListItem)MAPPER.readValue(webpage, (TypeReference)new TypeReference<ListItem<MovieInfo>>(){});
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get list", url, (Throwable)ex);
        }
    }

    public boolean checkItemStatus(String listId, int mediaId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, listId);
        parameters.add(Param.MOVIE_ID, mediaId);
        URL url = new ApiUrl(this.apiKey, MethodBase.LIST).subMethod(MethodSub.ITEM_STATUS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return ((ListItemStatus)MAPPER.readValue(webpage, ListItemStatus.class)).isItemPresent();
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get item status", url, (Throwable)ex);
        }
    }

    public String createList(String sessionId, String name, String description) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        String jsonBody = new PostTools().add(PostBody.NAME, (Object)StringUtils.trimToEmpty((String)name)).add(PostBody.DESCRIPTION, (Object)StringUtils.trimToEmpty((String)description)).build();
        URL url = new ApiUrl(this.apiKey, MethodBase.LIST).buildUrl(parameters);
        String webpage = this.httpTools.postRequest(url, jsonBody);
        try {
            return ((ListStatusCode)MAPPER.readValue(webpage, ListStatusCode.class)).getListId();
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to create list", url, (Throwable)ex);
        }
    }

    public StatusCode deleteList(String sessionId, String listId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, listId);
        parameters.add(Param.SESSION_ID, sessionId);
        URL url = new ApiUrl(this.apiKey, MethodBase.LIST).buildUrl(parameters);
        String webpage = this.httpTools.deleteRequest(url);
        try {
            return (StatusCode)MAPPER.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to delete list", url, (Throwable)ex);
        }
    }

    private StatusCode modifyMovieList(String sessionId, String listId, int movieId, MethodSub operation) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, listId);
        String jsonBody = new PostTools().add(PostBody.MEDIA_ID, (Object)movieId).build();
        URL url = new ApiUrl(this.apiKey, MethodBase.LIST).subMethod(operation).buildUrl(parameters);
        String webpage = this.httpTools.postRequest(url, jsonBody);
        try {
            return (StatusCode)MAPPER.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to remove item from list", url, (Throwable)ex);
        }
    }

    public StatusCode addItem(String sessionId, String listId, int mediaId) throws MovieDbException {
        return this.modifyMovieList(sessionId, listId, mediaId, MethodSub.ADD_ITEM);
    }

    public StatusCode removeItem(String sessionId, String listId, int mediaId) throws MovieDbException {
        return this.modifyMovieList(sessionId, listId, mediaId, MethodSub.REMOVE_ITEM);
    }

    public StatusCode clear(String sessionId, String listId, boolean confirm) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.ID, listId);
        parameters.add(Param.CONFIRM, confirm);
        URL url = new ApiUrl(this.apiKey, MethodBase.LIST).subMethod(MethodSub.CLEAR).buildUrl(parameters);
        String webpage = this.httpTools.postRequest(url, "");
        try {
            return (StatusCode)MAPPER.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to clear list", url, (Throwable)ex);
        }
    }
}

