/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.StatusCode;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.keyword.Keyword;
import com.omertron.themoviedbapi.model.list.UserList;
import com.omertron.themoviedbapi.model.media.AlternativeTitle;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.MediaState;
import com.omertron.themoviedbapi.model.media.Translation;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.movie.MovieInfo;
import com.omertron.themoviedbapi.model.movie.ReleaseDates;
import com.omertron.themoviedbapi.model.movie.ReleaseInfo;
import com.omertron.themoviedbapi.model.review.Review;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperAlternativeTitles;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperImages;
import com.omertron.themoviedbapi.results.WrapperMovieKeywords;
import com.omertron.themoviedbapi.results.WrapperReleaseInfo;
import com.omertron.themoviedbapi.results.WrapperTranslations;
import com.omertron.themoviedbapi.results.WrapperVideos;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.PostBody;
import com.omertron.themoviedbapi.tools.PostTools;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbMovies
extends AbstractMethod {
    private static final int RATING_MAX = 10;

    public TmdbMovies(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public MovieInfo getMovieInfo(int movieId, String language, String ... appendToResponse) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.APPEND, appendToResponse);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            MovieInfo movie = (MovieInfo)MAPPER.readValue(webpage, MovieInfo.class);
            if (movie == null || movie.getId() == 0) {
                throw new MovieDbException(ApiExceptionType.ID_NOT_FOUND, "No movie found for ID: " + movieId, url);
            }
            return movie;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get info", url, (Throwable)ex);
        }
    }

    public MovieInfo getMovieInfoImdb(String imdbId, String language, String ... appendToResponse) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, imdbId);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.APPEND, appendToResponse);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            MovieInfo movie = (MovieInfo)MAPPER.readValue(webpage, MovieInfo.class);
            if (movie == null || movie.getId() == 0) {
                throw new MovieDbException(ApiExceptionType.ID_NOT_FOUND, "No movie found for IMDB ID: " + imdbId, url);
            }
            return movie;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get info (IMDB)", url, (Throwable)ex);
        }
    }

    public MediaState getMovieAccountState(int movieId, String sessionId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.SESSION_ID, sessionId);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.ACCOUNT_STATES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MediaState)MAPPER.readValue(webpage, MediaState.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get account state", url, (Throwable)ex);
        }
    }

    public ResultList<AlternativeTitle> getMovieAlternativeTitles(int movieId, String country) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.COUNTRY, country);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.ALT_TITLES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperAlternativeTitles wrapper = (WrapperAlternativeTitles)MAPPER.readValue(webpage, WrapperAlternativeTitles.class);
            ResultList<AlternativeTitle> results = new ResultList<AlternativeTitle>(wrapper.getTitles());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get alternative titles", url, (Throwable)ex);
        }
    }

    public MediaCreditList getMovieCredits(int movieId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.CREDITS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MediaCreditList)MAPPER.readValue(webpage, MediaCreditList.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get credits", url, (Throwable)ex);
        }
    }

    public ResultList<Artwork> getMovieImages(int movieId, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.IMAGES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperImages wrapper = (WrapperImages)MAPPER.readValue(webpage, WrapperImages.class);
            ResultList<Artwork> results = new ResultList<Artwork>(wrapper.getAll(new ArtworkType[0]));
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get images", url, (Throwable)ex);
        }
    }

    public ResultList<Keyword> getMovieKeywords(int movieId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.KEYWORDS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperMovieKeywords wrapper = (WrapperMovieKeywords)MAPPER.readValue(webpage, WrapperMovieKeywords.class);
            ResultList<Keyword> results = new ResultList<Keyword>(wrapper.getKeywords());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get keywords", url, (Throwable)ex);
        }
    }

    public ResultList<ReleaseInfo> getMovieReleaseInfo(int movieId, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.RELEASES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperReleaseInfo wrapper = (WrapperReleaseInfo)MAPPER.readValue(webpage, WrapperReleaseInfo.class);
            ResultList<ReleaseInfo> results = new ResultList<ReleaseInfo>(wrapper.getCountries());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get release information", url, (Throwable)ex);
        }
    }

    public ResultList<Video> getMovieVideos(int movieId, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.VIDEOS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperVideos wrapper = (WrapperVideos)MAPPER.readValue(webpage, WrapperVideos.class);
            ResultList<Video> results = new ResultList<Video>(wrapper.getVideos());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get videos", url, (Throwable)ex);
        }
    }

    public ResultList<ReleaseDates> getReleaseDates(int movieId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.RELEASE_DATES).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbMovies.getTypeReference(ReleaseDates.class), url, "release dates");
        return wrapper.getResultsList();
    }

    public ResultList<Translation> getMovieTranslations(int movieId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.TRANSLATIONS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperTranslations wrapper = (WrapperTranslations)MAPPER.readValue(webpage, WrapperTranslations.class);
            ResultList<Translation> results = new ResultList<Translation>(wrapper.getTranslations());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get translations", url, (Throwable)ex);
        }
    }

    public ResultList<MovieInfo> getSimilarMovies(int movieId, Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.SIMILAR).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbMovies.getTypeReference(MovieInfo.class), url, "similar movies");
        return wrapper.getResultsList();
    }

    public ResultList<Review> getMovieReviews(int movieId, Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.REVIEWS).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbMovies.getTypeReference(Review.class), url, "review");
        return wrapper.getResultsList();
    }

    public ResultList<UserList> getMovieLists(int movieId, Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.LISTS).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbMovies.getTypeReference(UserList.class), url, "movie lists");
        return wrapper.getResultsList();
    }

    public ResultList<ChangeKeyItem> getMovieChanges(int movieId, String startDate, String endDate) throws MovieDbException {
        return this.getMediaChanges(movieId, startDate, endDate);
    }

    public StatusCode postMovieRating(int movieId, int rating, String sessionId, String guestSessionId) throws MovieDbException {
        if (rating < 0 || rating > 10) {
            throw new MovieDbException(ApiExceptionType.UNKNOWN_CAUSE, "Rating out of range");
        }
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, movieId);
        parameters.add(Param.SESSION_ID, sessionId);
        parameters.add(Param.GUEST_SESSION_ID, guestSessionId);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.RATING).buildUrl(parameters);
        String jsonBody = new PostTools().add(PostBody.VALUE, (Object)rating).build();
        String webpage = this.httpTools.postRequest(url, jsonBody);
        try {
            return (StatusCode)MAPPER.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to post rating", url, (Throwable)ex);
        }
    }

    public MovieInfo getLatestMovie() throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.LATEST).buildUrl();
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MovieInfo)MAPPER.readValue(webpage, MovieInfo.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get latest movie", url, (Throwable)ex);
        }
    }

    public ResultList<MovieInfo> getUpcoming(Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.UPCOMING).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbMovies.getTypeReference(MovieInfo.class), url, "upcoming movies");
        return wrapper.getResultsList();
    }

    public ResultList<MovieInfo> getNowPlayingMovies(Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.NOW_PLAYING).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbMovies.getTypeReference(MovieInfo.class), url, "now playing movies");
        return wrapper.getResultsList();
    }

    public ResultList<MovieInfo> getPopularMovieList(Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.POPULAR).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbMovies.getTypeReference(MovieInfo.class), url, "popular movie list");
        return wrapper.getResultsList();
    }

    public ResultList<MovieInfo> getTopRatedMovies(Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.MOVIE).subMethod(MethodSub.TOP_RATED).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbMovies.getTypeReference(MovieInfo.class), url, "top rated movies");
        return wrapper.getResultsList();
    }
}

