/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.network.Network;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbNetworks
extends AbstractMethod {
    public TmdbNetworks(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public Network getNetworkInfo(int networkId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, networkId);
        URL url = new ApiUrl(this.apiKey, MethodBase.NETWORK).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (Network)MAPPER.readValue(webpage, Network.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get network information", url, (Throwable)ex);
        }
    }
}

