/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.artwork.ArtworkMedia;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.credits.CreditBasic;
import com.omertron.themoviedbapi.model.credits.CreditMovieBasic;
import com.omertron.themoviedbapi.model.credits.CreditTVBasic;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.person.PersonCreditList;
import com.omertron.themoviedbapi.model.person.PersonCreditsMixIn;
import com.omertron.themoviedbapi.model.person.PersonFind;
import com.omertron.themoviedbapi.model.person.PersonInfo;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperImages;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbPeople
extends AbstractMethod {
    public TmdbPeople(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public PersonInfo getPersonInfo(int personId, String ... appendToResponse) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, personId);
        parameters.add(Param.APPEND, appendToResponse);
        String atr = (String)parameters.get(Param.APPEND);
        if (StringUtils.isNotBlank((CharSequence)atr) && atr.contains("combined_credits")) {
            atr = atr.replace("combined_credits", "tv_credits,movie_credits");
            parameters.add(Param.APPEND, atr);
        }
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (PersonInfo)MAPPER.readValue(webpage, PersonInfo.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get person info", url, (Throwable)ex);
        }
    }

    public PersonCreditList<CreditMovieBasic> getPersonMovieCredits(int personId, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, personId);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).subMethod(MethodSub.MOVIE_CREDITS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            TypeReference<PersonCreditList<CreditMovieBasic>> tr = new TypeReference<PersonCreditList<CreditMovieBasic>>(){};
            return (PersonCreditList)MAPPER.readValue(webpage, (TypeReference)tr);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get person movie credits", url, (Throwable)ex);
        }
    }

    public PersonCreditList<CreditTVBasic> getPersonTVCredits(int personId, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, personId);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).subMethod(MethodSub.TV_CREDITS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            TypeReference<PersonCreditList<CreditTVBasic>> tr = new TypeReference<PersonCreditList<CreditTVBasic>>(){};
            return (PersonCreditList)MAPPER.readValue(webpage, (TypeReference)tr);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get person TV credits", url, (Throwable)ex);
        }
    }

    public PersonCreditList<CreditBasic> getPersonCombinedCredits(int personId, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, personId);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).subMethod(MethodSub.COMBINED_CREDITS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.addMixIn(PersonCreditList.class, PersonCreditsMixIn.class);
            TypeReference<PersonCreditList<CreditBasic>> tr = new TypeReference<PersonCreditList<CreditBasic>>(){};
            return (PersonCreditList)mapper.readValue(webpage, (TypeReference)tr);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get person combined credits", url, (Throwable)ex);
        }
    }

    public ExternalID getPersonExternalIds(int personId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, personId);
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).subMethod(MethodSub.EXTERNAL_IDS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (ExternalID)MAPPER.readValue(webpage, ExternalID.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get person external IDs", url, (Throwable)ex);
        }
    }

    public ResultList<Artwork> getPersonImages(int personId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, personId);
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).subMethod(MethodSub.IMAGES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperImages wrapper = (WrapperImages)MAPPER.readValue(webpage, WrapperImages.class);
            ResultList<Artwork> results = new ResultList<Artwork>(wrapper.getAll(ArtworkType.PROFILE));
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get person images", url, (Throwable)ex);
        }
    }

    public ResultList<ArtworkMedia> getPersonTaggedImages(int personId, Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, personId);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).subMethod(MethodSub.TAGGED_IMAGES).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbPeople.getTypeReference(ArtworkMedia.class), url, "tagged images");
        return wrapper.getResultsList();
    }

    public ResultList<ChangeKeyItem> getPersonChanges(int personId, String startDate, String endDate) throws MovieDbException {
        return this.getMediaChanges(personId, startDate, endDate);
    }

    public ResultList<PersonFind> getPersonPopular(Integer page) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).subMethod(MethodSub.POPULAR).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbPeople.getTypeReference(PersonFind.class), url, "person popular");
        return wrapper.getResultsList();
    }

    public PersonInfo getPersonLatest() throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.PERSON).subMethod(MethodSub.LATEST).buildUrl();
        String webpage = this.httpTools.getRequest(url);
        try {
            return (PersonInfo)MAPPER.readValue(webpage, PersonInfo.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get latest person", url, (Throwable)ex);
        }
    }
}

