/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.review.Review;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbReviews
extends AbstractMethod {
    public TmdbReviews(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public Review getReview(String reviewId) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, reviewId);
        URL url = new ApiUrl(this.apiKey, MethodBase.REVIEW).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (Review)MAPPER.readValue(webpage, Review.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get review", url, (Throwable)ex);
        }
    }
}

