/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.SearchType;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.collection.Collection;
import com.omertron.themoviedbapi.model.company.Company;
import com.omertron.themoviedbapi.model.keyword.Keyword;
import com.omertron.themoviedbapi.model.list.UserList;
import com.omertron.themoviedbapi.model.media.MediaBasic;
import com.omertron.themoviedbapi.model.movie.MovieInfo;
import com.omertron.themoviedbapi.model.person.PersonFind;
import com.omertron.themoviedbapi.model.tv.TVBasic;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperMultiSearch;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbSearch
extends AbstractMethod {
    public TmdbSearch(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public ResultList<Company> searchCompanies(String query, Integer page) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.QUERY, query);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEARCH).subMethod(MethodSub.COMPANY).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbSearch.getTypeReference(Company.class), url, "company");
        return wrapper.getResultsList();
    }

    public ResultList<Collection> searchCollection(String query, Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.QUERY, query);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEARCH).subMethod(MethodSub.COLLECTION).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbSearch.getTypeReference(Collection.class), url, "collection");
        return wrapper.getResultsList();
    }

    public ResultList<Keyword> searchKeyword(String query, Integer page) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.QUERY, query);
        parameters.add(Param.PAGE, page);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEARCH).subMethod(MethodSub.KEYWORD).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbSearch.getTypeReference(Keyword.class), url, "keyword");
        return wrapper.getResultsList();
    }

    public ResultList<UserList> searchList(String query, Integer page, Boolean includeAdult) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.QUERY, query);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.INCLUDE_ADULT, includeAdult);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEARCH).subMethod(MethodSub.LIST).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbSearch.getTypeReference(UserList.class), url, "list");
        return wrapper.getResultsList();
    }

    public ResultList<MovieInfo> searchMovie(String query, Integer page, String language, Boolean includeAdult, Integer searchYear, Integer primaryReleaseYear, SearchType searchType) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.QUERY, query);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.ADULT, includeAdult);
        parameters.add(Param.YEAR, searchYear);
        parameters.add(Param.PRIMARY_RELEASE_YEAR, primaryReleaseYear);
        if (searchType != null) {
            parameters.add(Param.SEARCH_TYPE, searchType.getPropertyString());
        }
        URL url = new ApiUrl(this.apiKey, MethodBase.SEARCH).subMethod(MethodSub.MOVIE).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbSearch.getTypeReference(MovieInfo.class), url, "movie");
        return wrapper.getResultsList();
    }

    public ResultList<MediaBasic> searchMulti(String query, Integer page, String language, Boolean includeAdult) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.QUERY, query);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.ADULT, includeAdult);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEARCH).subMethod(MethodSub.MULTI).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperMultiSearch wrapper = (WrapperMultiSearch)MAPPER.readValue(webpage, WrapperMultiSearch.class);
            ResultList<MediaBasic> results = new ResultList<MediaBasic>();
            results.getResults().addAll(wrapper.getResults());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get multi search", url, (Throwable)ex);
        }
    }

    public ResultList<PersonFind> searchPeople(String query, Integer page, Boolean includeAdult, SearchType searchType) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.QUERY, query);
        parameters.add(Param.ADULT, includeAdult);
        parameters.add(Param.PAGE, page);
        if (searchType != null) {
            parameters.add(Param.SEARCH_TYPE, searchType.getPropertyString());
        }
        URL url = new ApiUrl(this.apiKey, MethodBase.SEARCH).subMethod(MethodSub.PERSON).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbSearch.getTypeReference(PersonFind.class), url, "person");
        return wrapper.getResultsList();
    }

    public ResultList<TVBasic> searchTV(String query, Integer page, String language, Integer firstAirDateYear, SearchType searchType) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.QUERY, query);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.FIRST_AIR_DATE_YEAR, firstAirDateYear);
        if (searchType != null) {
            parameters.add(Param.SEARCH_TYPE, searchType.getPropertyString());
        }
        URL url = new ApiUrl(this.apiKey, MethodBase.SEARCH).subMethod(MethodSub.TV).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbSearch.getTypeReference(TVBasic.class), url, "TV Show");
        return wrapper.getResultsList();
    }
}

