/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.MediaState;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.tv.TVSeasonInfo;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperImages;
import com.omertron.themoviedbapi.results.WrapperVideos;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbSeasons
extends AbstractMethod {
    public TmdbSeasons(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public TVSeasonInfo getSeasonInfo(int tvID, int seasonNumber, String language, String ... appendToResponse) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.APPEND, appendToResponse);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEASON).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (TVSeasonInfo)MAPPER.readValue(webpage, TVSeasonInfo.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get TV Season Info", url, (Throwable)ex);
        }
    }

    public ResultList<ChangeKeyItem> getSeasonChanges(int tvID, String startDate, String endDate) throws MovieDbException {
        return this.getMediaChanges(tvID, startDate, endDate);
    }

    public MediaState getSeasonAccountState(int tvID, String sessionID) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SESSION_ID, sessionID);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEASON).subMethod(MethodSub.ACCOUNT_STATES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MediaState)MAPPER.readValue(webpage, MediaState.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get account state", url, (Throwable)ex);
        }
    }

    public MediaCreditList getSeasonCredits(int tvID, int seasonNumber) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEASON).subMethod(MethodSub.CREDITS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MediaCreditList)MAPPER.readValue(webpage, MediaCreditList.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get credits", url, (Throwable)ex);
        }
    }

    public ExternalID getSeasonExternalID(int tvID, int seasonNumber, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEASON).subMethod(MethodSub.EXTERNAL_IDS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (ExternalID)MAPPER.readValue(webpage, ExternalID.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get external IDs", url, (Throwable)ex);
        }
    }

    public ResultList<Artwork> getSeasonImages(int tvID, int seasonNumber, String language, String ... includeImageLanguage) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.APPEND, includeImageLanguage);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEASON).subMethod(MethodSub.IMAGES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperImages wrapper = (WrapperImages)MAPPER.readValue(webpage, WrapperImages.class);
            ResultList<Artwork> results = new ResultList<Artwork>(wrapper.getAll(new ArtworkType[0]));
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get images", url, (Throwable)ex);
        }
    }

    public ResultList<Video> getSeasonVideos(int tvID, int seasonNumber, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SEASON_NUMBER, seasonNumber);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.SEASON).subMethod(MethodSub.VIDEOS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperVideos wrapper = (WrapperVideos)MAPPER.readValue(webpage, WrapperVideos.class);
            ResultList<Video> results = new ResultList<Video>(wrapper.getVideos());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get videos", url, (Throwable)ex);
        }
    }
}

