/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.methods;

import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.methods.AbstractMethod;
import com.omertron.themoviedbapi.model.StatusCode;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.keyword.Keyword;
import com.omertron.themoviedbapi.model.media.AlternativeTitle;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.MediaState;
import com.omertron.themoviedbapi.model.media.Translation;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.person.ContentRating;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.tv.TVInfo;
import com.omertron.themoviedbapi.results.ResultList;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperImages;
import com.omertron.themoviedbapi.results.WrapperTranslations;
import com.omertron.themoviedbapi.results.WrapperVideos;
import com.omertron.themoviedbapi.tools.ApiUrl;
import com.omertron.themoviedbapi.tools.HttpTools;
import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.PostBody;
import com.omertron.themoviedbapi.tools.PostTools;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.IOException;
import java.net.URL;
import org.yamj.api.common.exception.ApiExceptionType;

public class TmdbTV
extends AbstractMethod {
    private static final int RATING_MAX = 10;

    public TmdbTV(String apiKey, HttpTools httpTools) {
        super(apiKey, httpTools);
    }

    public TVInfo getTVInfo(int tvID, String language, String ... appendToResponse) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.APPEND, appendToResponse);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (TVInfo)MAPPER.readValue(webpage, TVInfo.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get TV Info", url, (Throwable)ex);
        }
    }

    public MediaState getTVAccountState(int tvID, String sessionID) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SESSION_ID, sessionID);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.ACCOUNT_STATES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MediaState)MAPPER.readValue(webpage, MediaState.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get account state", url, (Throwable)ex);
        }
    }

    public ResultList<AlternativeTitle> getTVAlternativeTitles(int tvID) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.ALT_TITLES).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbTV.getTypeReference(AlternativeTitle.class), url, "alternative titles");
        return wrapper.getResultsList();
    }

    public ResultList<ChangeKeyItem> getTVChanges(int tvID, String startDate, String endDate) throws MovieDbException {
        return this.getMediaChanges(tvID, startDate, endDate);
    }

    public ResultList<ContentRating> getTVContentRatings(int tvID) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.CONTENT_RATINGS).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbTV.getTypeReference(ContentRating.class), url, "content rating");
        return wrapper.getResultsList();
    }

    public MediaCreditList getTVCredits(int tvID, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.CREDITS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (MediaCreditList)MAPPER.readValue(webpage, MediaCreditList.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get credits", url, (Throwable)ex);
        }
    }

    public ExternalID getTVExternalIDs(int tvID, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.EXTERNAL_IDS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            return (ExternalID)MAPPER.readValue(webpage, ExternalID.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get external IDs", url, (Throwable)ex);
        }
    }

    public ResultList<Artwork> getTVImages(int tvID, String language, String ... includeImageLanguage) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.INCLUDE_IMAGE_LANGUAGE, includeImageLanguage);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.IMAGES).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperImages wrapper = (WrapperImages)MAPPER.readValue(webpage, WrapperImages.class);
            ResultList<Artwork> results = new ResultList<Artwork>(wrapper.getAll(new ArtworkType[0]));
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get images", url, (Throwable)ex);
        }
    }

    public ResultList<Keyword> getTVKeywords(int tvID) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.KEYWORDS).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbTV.getTypeReference(Keyword.class), url, "keywords");
        return wrapper.getResultsList();
    }

    public StatusCode postTVRating(int tvID, int rating, String sessionID, String guestSessionID) throws MovieDbException {
        if (rating < 0 || rating > 10) {
            throw new MovieDbException(ApiExceptionType.UNKNOWN_CAUSE, "Rating out of range");
        }
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.SESSION_ID, sessionID);
        parameters.add(Param.GUEST_SESSION_ID, guestSessionID);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.RATING).buildUrl(parameters);
        String jsonBody = new PostTools().add(PostBody.VALUE, (Object)rating).build();
        String webpage = this.httpTools.postRequest(url, jsonBody);
        try {
            return (StatusCode)MAPPER.readValue(webpage, StatusCode.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to post rating", url, (Throwable)ex);
        }
    }

    public ResultList<TVInfo> getTVSimilar(int tvID, Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.SIMILAR).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbTV.getTypeReference(TVInfo.class), url, "similar TV shows");
        return wrapper.getResultsList();
    }

    public ResultList<Translation> getTVTranslations(int tvID) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.TRANSLATIONS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperTranslations wrapper = (WrapperTranslations)MAPPER.readValue(webpage, WrapperTranslations.class);
            ResultList<Translation> results = new ResultList<Translation>(wrapper.getTranslations());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get translations", url, (Throwable)ex);
        }
    }

    public ResultList<Video> getTVVideos(int tvID, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.ID, tvID);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.VIDEOS).buildUrl(parameters);
        String webpage = this.httpTools.getRequest(url);
        try {
            WrapperVideos wrapper = (WrapperVideos)MAPPER.readValue(webpage, WrapperVideos.class);
            ResultList<Video> results = new ResultList<Video>(wrapper.getVideos());
            wrapper.setResultProperties(results);
            return results;
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get videos", url, (Throwable)ex);
        }
    }

    public TVInfo getLatestTV() throws MovieDbException {
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.LATEST).buildUrl();
        String webpage = this.httpTools.getRequest(url);
        try {
            return (TVInfo)MAPPER.readValue(webpage, TVInfo.class);
        }
        catch (IOException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "Failed to get latest TV show", url, (Throwable)ex);
        }
    }

    public ResultList<TVInfo> getTVOnTheAir(Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.ON_THE_AIR).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbTV.getTypeReference(TVInfo.class), url, "on the air");
        return wrapper.getResultsList();
    }

    public ResultList<TVInfo> getTVAiringToday(Integer page, String language, String timezone) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        parameters.add(Param.TIMEZONE, timezone);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.AIRING_TODAY).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbTV.getTypeReference(TVInfo.class), url, "airing today");
        return wrapper.getResultsList();
    }

    public ResultList<TVInfo> getTVTopRated(Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.TOP_RATED).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbTV.getTypeReference(TVInfo.class), url, "top rated TV shows");
        return wrapper.getResultsList();
    }

    public ResultList<TVInfo> getTVPopular(Integer page, String language) throws MovieDbException {
        TmdbParameters parameters = new TmdbParameters();
        parameters.add(Param.PAGE, page);
        parameters.add(Param.LANGUAGE, language);
        URL url = new ApiUrl(this.apiKey, MethodBase.TV).subMethod(MethodSub.POPULAR).buildUrl(parameters);
        WrapperGenericList wrapper = this.processWrapper(TmdbTV.getTypeReference(TVInfo.class), url, "popular TV shows");
        return wrapper.getResultsList();
    }
}

