/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model.artwork;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.omertron.themoviedbapi.enumeration.MediaType;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.media.MediaBasic;
import com.omertron.themoviedbapi.model.movie.MovieBasic;
import com.omertron.themoviedbapi.model.tv.TVBasic;
import com.omertron.themoviedbapi.model.tv.TVEpisodeBasic;
import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ArtworkMedia
extends Artwork
implements Serializable {
    private static final long serialVersionUID = 100L;
    private MediaType mediaType;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="media_type", defaultImpl=MediaBasic.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=MovieBasic.class, name="movie"), @JsonSubTypes.Type(value=TVBasic.class, name="tv"), @JsonSubTypes.Type(value=TVEpisodeBasic.class, name="episode")})
    @JsonProperty(value="media")
    private MediaBasic media;

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @JsonSetter(value="media_type")
    public void setMediaType(String mediaType) {
        this.mediaType = MediaType.fromString(mediaType);
    }

    public MediaBasic getMedia() {
        return this.media;
    }

    public void setMedia(MediaBasic media) {
        this.media = media;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.mediaType).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ArtworkMedia) {
            ArtworkMedia other = (ArtworkMedia)obj;
            return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.mediaType, (Object)other.mediaType).isEquals();
        }
        return false;
    }
}

