/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model.discover;

import com.omertron.themoviedbapi.enumeration.SortBy;
import com.omertron.themoviedbapi.model.discover.WithBuilder;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;

public class Discover {
    private final TmdbParameters params = new TmdbParameters();
    private static final int YEAR_MIN = 1900;
    private static final int YEAR_MAX = 2100;

    public TmdbParameters getParams() {
        return this.params;
    }

    public Discover page(int page) {
        this.params.add(Param.PAGE, page);
        return this;
    }

    public Discover language(String language) {
        this.params.add(Param.LANGUAGE, language);
        return this;
    }

    public Discover sortBy(SortBy sortBy) {
        this.params.add(Param.SORT_BY, sortBy.getPropertyString());
        return this;
    }

    public Discover includeAdult(boolean includeAdult) {
        this.params.add(Param.ADULT, includeAdult);
        return this;
    }

    public Discover includeVideo(boolean includeVideo) {
        this.params.add(Param.INCLUDE_VIDEO, includeVideo);
        return this;
    }

    public Discover year(int year) {
        if (this.checkYear(year)) {
            this.params.add(Param.YEAR, year);
        }
        return this;
    }

    public Discover primaryReleaseYear(int primaryReleaseYear) {
        if (this.checkYear(primaryReleaseYear)) {
            this.params.add(Param.PRIMARY_RELEASE_YEAR, primaryReleaseYear);
        }
        return this;
    }

    public Discover voteCountGte(int voteCountGte) {
        this.params.add(Param.VOTE_COUNT_GTE, voteCountGte);
        return this;
    }

    public Discover voteCountLte(int voteCountLte) {
        this.params.add(Param.VOTE_COUNT_LTE, voteCountLte);
        return this;
    }

    public Discover voteAverageGte(float voteAverageGte) {
        this.params.add(Param.VOTE_AVERAGE_GTE, Float.valueOf(voteAverageGte));
        return this;
    }

    public Discover voteAverageLte(float voteAverageLte) {
        this.params.add(Param.VOTE_AVERAGE_LTE, Float.valueOf(voteAverageLte));
        return this;
    }

    public Discover releaseDateGte(String releaseDateGte) {
        this.params.add(Param.RELEASE_DATE_GTE, releaseDateGte);
        return this;
    }

    public Discover releaseDateLte(String releaseDateLte) {
        this.params.add(Param.RELEASE_DATE_LTE, releaseDateLte);
        return this;
    }

    public Discover certificationCountry(String certificationCountry) {
        this.params.add(Param.CERTIFICATION_COUNTRY, certificationCountry);
        return this;
    }

    public Discover certificationLte(String certificationLte) {
        this.params.add(Param.CERTIFICATION_LTE, certificationLte);
        return this;
    }

    public Discover certification(String certification) {
        this.params.add(Param.CERTIFICATION, certification);
        return this;
    }

    public Discover withCast(String withCast) {
        this.params.add(Param.WITH_CAST, withCast);
        return this;
    }

    public Discover withCast(WithBuilder withCast) {
        return this.withCast(withCast.build());
    }

    public Discover withCrew(String withCrew) {
        this.params.add(Param.WITH_CREW, withCrew);
        return this;
    }

    public Discover withCrew(WithBuilder withCrew) {
        return this.withCrew(withCrew.build());
    }

    public Discover withCompanies(String withCompanies) {
        this.params.add(Param.WITH_COMPANIES, withCompanies);
        return this;
    }

    public Discover withCompanies(WithBuilder withCompanies) {
        return this.withCompanies(withCompanies.build());
    }

    public Discover withGenres(String withGenres) {
        this.params.add(Param.WITH_GENRES, withGenres);
        return this;
    }

    public Discover withGenres(WithBuilder withGenres) {
        return this.withGenres(withGenres.build());
    }

    public Discover withKeywords(String withKeywords) {
        this.params.add(Param.WITH_KEYWORDS, withKeywords);
        return this;
    }

    public Discover withKeywords(WithBuilder withKeywords) {
        return this.withKeywords(withKeywords.build());
    }

    public Discover withPeople(String withPeople) {
        this.params.add(Param.WITH_PEOPLE, withPeople);
        return this;
    }

    public Discover withPeople(WithBuilder withPeople) {
        return this.withPeople(withPeople.build());
    }

    public Discover firstAirDateYear(int year) {
        if (this.checkYear(year)) {
            this.params.add(Param.FIRST_AIR_DATE_YEAR, year);
        }
        return this;
    }

    public Discover firstAirDateYearGte(int year) {
        if (this.checkYear(year)) {
            this.params.add(Param.FIRST_AIR_DATE_GTE, year);
        }
        return this;
    }

    public Discover firstAirDateYearLte(int year) {
        if (this.checkYear(year)) {
            this.params.add(Param.FIRST_AIR_DATE_LTE, year);
        }
        return this;
    }

    public Discover withNetworks(String withNetworks) {
        this.params.add(Param.WITH_NETWORKS, withNetworks);
        return this;
    }

    public Discover withNetworks(WithBuilder withNetworks) {
        return this.withNetworks(withNetworks.build());
    }

    private boolean checkYear(int year) {
        return year >= 1900 && year <= 2100;
    }
}

