/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model.movie;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.enumeration.MovieMethod;
import com.omertron.themoviedbapi.interfaces.AppendToResponse;
import com.omertron.themoviedbapi.interfaces.Identification;
import com.omertron.themoviedbapi.model.Genre;
import com.omertron.themoviedbapi.model.Language;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.collection.Collection;
import com.omertron.themoviedbapi.model.credits.MediaCreditCast;
import com.omertron.themoviedbapi.model.credits.MediaCreditCrew;
import com.omertron.themoviedbapi.model.keyword.Keyword;
import com.omertron.themoviedbapi.model.list.UserList;
import com.omertron.themoviedbapi.model.media.AlternativeTitle;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.Translation;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.movie.MovieBasic;
import com.omertron.themoviedbapi.model.movie.ProductionCompany;
import com.omertron.themoviedbapi.model.movie.ProductionCountry;
import com.omertron.themoviedbapi.model.movie.ReleaseInfo;
import com.omertron.themoviedbapi.model.review.Review;
import com.omertron.themoviedbapi.results.WrapperAlternativeTitles;
import com.omertron.themoviedbapi.results.WrapperChanges;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperImages;
import com.omertron.themoviedbapi.results.WrapperMovieKeywords;
import com.omertron.themoviedbapi.results.WrapperReleaseInfo;
import com.omertron.themoviedbapi.results.WrapperTranslations;
import com.omertron.themoviedbapi.results.WrapperVideos;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class MovieInfo
extends MovieBasic
implements Serializable,
Identification,
AppendToResponse<MovieMethod> {
    private static final long serialVersionUID = 100L;
    @JsonProperty(value="belongs_to_collection")
    private Collection belongsToCollection;
    @JsonProperty(value="budget")
    private long budget;
    @JsonProperty(value="genres")
    private List<Genre> genres;
    @JsonProperty(value="homepage")
    private String homepage;
    @JsonProperty(value="imdb_id")
    private String imdbID;
    @JsonProperty(value="production_companies")
    private List<ProductionCompany> productionCompanies = Collections.emptyList();
    @JsonProperty(value="production_countries")
    private List<ProductionCountry> productionCountries = Collections.emptyList();
    @JsonProperty(value="runtime")
    private int runtime;
    @JsonProperty(value="spoken_languages")
    private List<Language> spokenLanguages = Collections.emptyList();
    @JsonProperty(value="tagline")
    private String tagline;
    @JsonProperty(value="status")
    private String status;
    private final Set<MovieMethod> methods = EnumSet.noneOf(MovieMethod.class);
    private List<AlternativeTitle> alternativeTitles = Collections.emptyList();
    private MediaCreditList credits = new MediaCreditList();
    private List<Artwork> images = Collections.emptyList();
    private List<Keyword> keywords = Collections.emptyList();
    private List<ReleaseInfo> releases = Collections.emptyList();
    private List<Video> videos = Collections.emptyList();
    private List<Translation> translations = Collections.emptyList();
    private List<MovieInfo> similarMovies = Collections.emptyList();
    private List<Review> reviews = Collections.emptyList();
    private List<UserList> lists = Collections.emptyList();
    private List<ChangeKeyItem> changes = Collections.emptyList();

    public Collection getBelongsToCollection() {
        return this.belongsToCollection;
    }

    public long getBudget() {
        return this.budget;
    }

    public List<Genre> getGenres() {
        return this.genres;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getImdbID() {
        return this.imdbID;
    }

    public List<ProductionCompany> getProductionCompanies() {
        return this.productionCompanies;
    }

    public List<ProductionCountry> getProductionCountries() {
        return this.productionCountries;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public List<Language> getSpokenLanguages() {
        return this.spokenLanguages;
    }

    public String getTagline() {
        return this.tagline;
    }

    public String getStatus() {
        return this.status;
    }

    public void setBelongsToCollection(Collection belongsToCollection) {
        this.belongsToCollection = belongsToCollection;
    }

    public void setBudget(long budget) {
        this.budget = budget;
    }

    public void setGenres(List<Genre> genres) {
        this.genres = genres;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setImdbID(String imdbID) {
        this.imdbID = imdbID;
    }

    public void setProductionCompanies(List<ProductionCompany> productionCompanies) {
        this.productionCompanies = productionCompanies;
    }

    public void setProductionCountries(List<ProductionCountry> productionCountries) {
        this.productionCountries = productionCountries;
    }

    public void setRuntime(int runtime) {
        this.runtime = runtime;
    }

    public void setSpokenLanguages(List<Language> spokenLanguages) {
        this.spokenLanguages = spokenLanguages;
    }

    public void setTagline(String tagline) {
        this.tagline = tagline;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<AlternativeTitle> getAlternativeTitles() {
        return this.alternativeTitles;
    }

    public List<MediaCreditCast> getCast() {
        return this.credits.getCast();
    }

    public List<MediaCreditCrew> getCrew() {
        return this.credits.getCrew();
    }

    public List<Artwork> getImages() {
        return this.images;
    }

    public List<Keyword> getKeywords() {
        return this.keywords;
    }

    public List<ReleaseInfo> getReleases() {
        return this.releases;
    }

    public List<Video> getVideos() {
        return this.videos;
    }

    public List<Translation> getTranslations() {
        return this.translations;
    }

    public List<MovieInfo> getSimilarMovies() {
        return this.similarMovies;
    }

    public List<UserList> getLists() {
        return this.lists;
    }

    public List<Review> getReviews() {
        return this.reviews;
    }

    public List<ChangeKeyItem> getChanges() {
        return this.changes;
    }

    @JsonSetter(value="alternative_titles")
    public void setAlternativeTitles(WrapperAlternativeTitles alternativeTitles) {
        this.alternativeTitles = alternativeTitles.getTitles();
        this.addMethod(MovieMethod.ALTERNATIVE_TITLES);
    }

    @JsonSetter(value="credits")
    public void setCredits(MediaCreditList credits) {
        this.credits = credits;
        this.addMethod(MovieMethod.CREDITS);
    }

    @JsonSetter(value="images")
    public void setImages(WrapperImages images) {
        this.images = images.getAll(new ArtworkType[0]);
        this.addMethod(MovieMethod.IMAGES);
    }

    @JsonSetter(value="keywords")
    public void setKeywords(WrapperMovieKeywords keywords) {
        this.keywords = keywords.getKeywords();
        this.addMethod(MovieMethod.KEYWORDS);
    }

    @JsonSetter(value="releases")
    public void setReleases(WrapperReleaseInfo releases) {
        this.releases = releases.getCountries();
        this.addMethod(MovieMethod.RELEASES);
    }

    @JsonSetter(value="videos")
    public void setVideos(WrapperVideos trailers) {
        this.videos = trailers.getVideos();
        this.addMethod(MovieMethod.VIDEOS);
    }

    @JsonSetter(value="translations")
    public void setTranslations(WrapperTranslations translations) {
        this.translations = translations.getTranslations();
        this.addMethod(MovieMethod.TRANSLATIONS);
    }

    @JsonSetter(value="similar")
    public void setSimilarMovies(WrapperGenericList<MovieInfo> similarMovies) {
        this.similarMovies = similarMovies.getResults();
        this.addMethod(MovieMethod.SIMILAR);
    }

    @JsonSetter(value="lists")
    public void setLists(WrapperGenericList<UserList> lists) {
        this.lists = lists.getResults();
        this.addMethod(MovieMethod.LISTS);
    }

    @JsonSetter(value="reviews")
    public void setReviews(WrapperGenericList<Review> reviews) {
        this.reviews = reviews.getResults();
        this.addMethod(MovieMethod.REVIEWS);
    }

    @JsonSetter(value="changes")
    public void setChanges(WrapperChanges changes) {
        this.changes = changes.getChangedItems();
    }

    private void addMethod(MovieMethod method) {
        this.methods.add(method);
    }

    @Override
    public boolean hasMethod(MovieMethod method) {
        return this.methods.contains(method);
    }
}

