/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model.person;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.enumeration.Gender;
import com.omertron.themoviedbapi.enumeration.PeopleMethod;
import com.omertron.themoviedbapi.interfaces.AppendToResponse;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.artwork.ArtworkMedia;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.credits.CreditMovieBasic;
import com.omertron.themoviedbapi.model.credits.CreditTVBasic;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.person.PersonBasic;
import com.omertron.themoviedbapi.model.person.PersonCreditList;
import com.omertron.themoviedbapi.results.WrapperChanges;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperImages;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class PersonInfo
extends PersonBasic
implements Serializable,
AppendToResponse<PeopleMethod> {
    private static final long serialVersionUID = 100L;
    @JsonProperty(value="adult")
    private boolean adult;
    @JsonProperty(value="also_known_as")
    private List<String> alsoKnownAs;
    @JsonProperty(value="biography")
    private String biography;
    @JsonProperty(value="birthday")
    private String birthday;
    @JsonProperty(value="deathday")
    private String deathday;
    @JsonProperty(value="homepage")
    private String homepage;
    @JsonProperty(value="imdb_id")
    private String imdbId;
    @JsonProperty(value="place_of_birth")
    private String placeOfBirth;
    @JsonProperty(value="popularity")
    private float popularity;
    private Gender gender;
    private final Set<PeopleMethod> methods = EnumSet.noneOf(PeopleMethod.class);
    private List<ChangeKeyItem> changes = Collections.emptyList();
    private ExternalID externalIDs = new ExternalID();
    private List<Artwork> images = Collections.emptyList();
    private List<ArtworkMedia> taggedImages = Collections.emptyList();
    private PersonCreditList<CreditMovieBasic> movieCredits = new PersonCreditList();
    private PersonCreditList<CreditTVBasic> tvCredits = new PersonCreditList();

    public boolean isAdult() {
        return this.adult;
    }

    public void setAdult(boolean adult) {
        this.adult = adult;
    }

    public List<String> getAlsoKnownAs() {
        return this.alsoKnownAs;
    }

    public void setAlsoKnownAs(List<String> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public String getBiography() {
        return this.biography;
    }

    public void setBiography(String biography) {
        this.biography = biography;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getDeathday() {
        return this.deathday;
    }

    public void setDeathday(String deathday) {
        this.deathday = deathday;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getImdbId() {
        return this.imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public String getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public void setPlaceOfBirth(String placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
    }

    public float getPopularity() {
        return this.popularity;
    }

    public void setPopularity(float popularity) {
        this.popularity = popularity;
    }

    private void addMethod(PeopleMethod method) {
        this.methods.add(method);
    }

    public Gender getGender() {
        return this.gender;
    }

    @JsonSetter(value="gender")
    public void setGender(int gender) {
        this.gender = Gender.fromInteger(gender);
    }

    @Override
    public boolean hasMethod(PeopleMethod method) {
        return this.methods.contains(method);
    }

    @JsonSetter(value="changes")
    public void setChanges(WrapperChanges changes) {
        this.changes = changes.getChangedItems();
        this.addMethod(PeopleMethod.CHANGES);
    }

    @JsonSetter(value="external_ids")
    public void setExternalIDs(ExternalID externalIDs) {
        this.externalIDs = externalIDs;
        this.addMethod(PeopleMethod.EXTERNAL_IDS);
    }

    @JsonSetter(value="images")
    public void setImages(WrapperImages images) {
        this.images = images.getAll(new ArtworkType[0]);
        this.addMethod(PeopleMethod.IMAGES);
    }

    @JsonSetter(value="movie_credits")
    public void setMovieCredits(PersonCreditList<CreditMovieBasic> movieCredits) {
        this.movieCredits = movieCredits;
        this.addMethod(PeopleMethod.MOVIE_CREDITS);
    }

    @JsonSetter(value="tagged_images")
    public void setTaggedImages(WrapperGenericList<ArtworkMedia> taggedImages) {
        this.taggedImages = taggedImages.getResults();
        this.addMethod(PeopleMethod.TAGGED_IMAGES);
    }

    @JsonSetter(value="tv_credits")
    public void setTvCredits(PersonCreditList<CreditTVBasic> tvCredits) {
        this.tvCredits = tvCredits;
        this.addMethod(PeopleMethod.TV_CREDITS);
    }

    public List<ChangeKeyItem> getChanges() {
        return this.changes;
    }

    public ExternalID getExternalIDs() {
        return this.externalIDs;
    }

    public List<Artwork> getImages() {
        return this.images;
    }

    public PersonCreditList<CreditMovieBasic> getMovieCredits() {
        return this.movieCredits;
    }

    public List<ArtworkMedia> getTaggedImages() {
        return this.taggedImages;
    }

    public PersonCreditList<CreditTVBasic> getTvCredits() {
        return this.tvCredits;
    }
}

