/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model.tv;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.enumeration.TVEpisodeMethod;
import com.omertron.themoviedbapi.interfaces.AppendToResponse;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.credits.MediaCreditCast;
import com.omertron.themoviedbapi.model.credits.MediaCreditCrew;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.tv.TVEpisodeBasic;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperImages;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class TVEpisodeInfo
extends TVEpisodeBasic
implements Serializable,
AppendToResponse<TVEpisodeMethod> {
    private static final long serialVersionUID = 100L;
    @JsonProperty(value="crew")
    private List<MediaCreditCrew> crew;
    @JsonProperty(value="guest_stars")
    private List<MediaCreditCast> guestStars;
    @JsonProperty(value="production_code")
    private String productionCode;
    private final Set<TVEpisodeMethod> methods = EnumSet.noneOf(TVEpisodeMethod.class);
    private MediaCreditList credits = new MediaCreditList();
    private ExternalID externalIDs = new ExternalID();
    private List<Artwork> images = Collections.emptyList();
    private List<Video> videos = Collections.emptyList();

    public List<MediaCreditCrew> getCrew() {
        return this.crew;
    }

    public void setCrew(List<MediaCreditCrew> crew) {
        this.crew = crew;
    }

    public List<MediaCreditCast> getGuestStars() {
        return this.guestStars;
    }

    public void setGuestStars(List<MediaCreditCast> guestStars) {
        this.guestStars = guestStars;
    }

    public String getProductionCode() {
        return this.productionCode;
    }

    public void setProductionCode(String productionCode) {
        this.productionCode = productionCode;
    }

    private void addMethod(TVEpisodeMethod method) {
        this.methods.add(method);
    }

    @Override
    public boolean hasMethod(TVEpisodeMethod method) {
        return this.methods.contains(method);
    }

    @JsonSetter(value="credits")
    public void setCredits(MediaCreditList credits) {
        this.credits = credits;
        this.addMethod(TVEpisodeMethod.CREDITS);
    }

    @JsonSetter(value="external_ids")
    public void setExternalIDs(ExternalID externalIDs) {
        this.externalIDs = externalIDs;
        this.addMethod(TVEpisodeMethod.EXTERNAL_IDS);
    }

    @JsonSetter(value="images")
    public void setImages(WrapperImages images) {
        this.images = images.getAll(new ArtworkType[0]);
        this.addMethod(TVEpisodeMethod.IMAGES);
    }

    @JsonSetter(value="videos")
    public void setVideos(WrapperGenericList<Video> videos) {
        this.videos = videos.getResults();
        this.addMethod(TVEpisodeMethod.VIDEOS);
    }

    public MediaCreditList getCredits() {
        return this.credits;
    }

    public ExternalID getExternalIDs() {
        return this.externalIDs;
    }

    public List<Artwork> getImages() {
        return this.images;
    }

    public List<Video> getVideos() {
        return this.videos;
    }
}

