/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model.tv;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.enumeration.TVMethod;
import com.omertron.themoviedbapi.interfaces.AppendToResponse;
import com.omertron.themoviedbapi.model.Genre;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.change.ChangeKeyItem;
import com.omertron.themoviedbapi.model.keyword.Keyword;
import com.omertron.themoviedbapi.model.media.AlternativeTitle;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.Translation;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.movie.ProductionCompany;
import com.omertron.themoviedbapi.model.network.Network;
import com.omertron.themoviedbapi.model.person.ContentRating;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.person.PersonBasic;
import com.omertron.themoviedbapi.model.tv.TVBasic;
import com.omertron.themoviedbapi.model.tv.TVSeasonBasic;
import com.omertron.themoviedbapi.results.WrapperChanges;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperImages;
import com.omertron.themoviedbapi.results.WrapperTranslations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class TVInfo
extends TVBasic
implements Serializable,
AppendToResponse<TVMethod> {
    private static final long serialVersionUID = 100L;
    @JsonProperty(value="created_by")
    private List<PersonBasic> createdBy;
    @JsonProperty(value="episode_run_time")
    private List<Integer> episodeRunTime;
    @JsonProperty(value="genres")
    private List<Genre> genres;
    @JsonProperty(value="homepage")
    private String homepage;
    @JsonProperty(value="in_production")
    private boolean inProduction;
    @JsonProperty(value="languages")
    private List<String> languages;
    @JsonProperty(value="last_air_date")
    private String lastAirDate;
    @JsonProperty(value="networks")
    private List<Network> networks;
    @JsonProperty(value="number_of_episodes")
    private int numberOfEpisodes;
    @JsonProperty(value="number_of_seasons")
    private int numberOfSeasons;
    @JsonProperty(value="original_language")
    private String originalLanguage;
    @JsonProperty(value="overview")
    private String overview;
    @JsonProperty(value="production_companies")
    private List<ProductionCompany> productionCompanies;
    @JsonProperty(value="seasons")
    private List<TVSeasonBasic> seasons;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="type")
    private String type;
    private final Set<TVMethod> methods = EnumSet.noneOf(TVMethod.class);
    private List<AlternativeTitle> alternativeTitles = Collections.emptyList();
    private List<ChangeKeyItem> changes = Collections.emptyList();
    private List<ContentRating> contentRatings = Collections.emptyList();
    private MediaCreditList credits = new MediaCreditList();
    private ExternalID externalIDs = new ExternalID();
    private List<Artwork> images = Collections.emptyList();
    private List<Keyword> keywords = Collections.emptyList();
    private List<Translation> translations = Collections.emptyList();
    private List<TVInfo> similarTV = Collections.emptyList();
    private List<Video> videos = Collections.emptyList();

    public List<PersonBasic> getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(List<PersonBasic> createdBy) {
        this.createdBy = createdBy;
    }

    public List<Integer> getEpisodeRunTime() {
        return this.episodeRunTime;
    }

    public void setEpisodeRunTime(List<Integer> episodeRunTime) {
        this.episodeRunTime = episodeRunTime;
    }

    public List<Genre> getGenres() {
        return this.genres;
    }

    public void setGenres(List<Genre> genres) {
        this.genres = genres;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public boolean isInProduction() {
        return this.inProduction;
    }

    public void setInProduction(boolean inProduction) {
        this.inProduction = inProduction;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public String getLastAirDate() {
        return this.lastAirDate;
    }

    public void setLastAirDate(String lastAirDate) {
        this.lastAirDate = lastAirDate;
    }

    public List<Network> getNetworks() {
        return this.networks;
    }

    public void setNetworks(List<Network> networks) {
        this.networks = networks;
    }

    public int getNumberOfEpisodes() {
        return this.numberOfEpisodes;
    }

    public void setNumberOfEpisodes(int numberOfEpisodes) {
        this.numberOfEpisodes = numberOfEpisodes;
    }

    public int getNumberOfSeasons() {
        return this.numberOfSeasons;
    }

    public void setNumberOfSeasons(int numberOfSeasons) {
        this.numberOfSeasons = numberOfSeasons;
    }

    @Override
    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    @Override
    public void setOriginalLanguage(String originalLanguage) {
        this.originalLanguage = originalLanguage;
    }

    @Override
    public String getOverview() {
        return this.overview;
    }

    @Override
    public void setOverview(String overview) {
        this.overview = overview;
    }

    public List<ProductionCompany> getProductionCompanies() {
        return this.productionCompanies;
    }

    public void setProductionCompanies(List<ProductionCompany> productionCompanies) {
        this.productionCompanies = productionCompanies;
    }

    public List<TVSeasonBasic> getSeasons() {
        return this.seasons;
    }

    public void setSeasons(List<TVSeasonBasic> seasons) {
        this.seasons = seasons;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    @JsonSetter(value="genre_ids")
    public void setGenreIds(List<Integer> ids) {
        this.genres = new ArrayList<Genre>();
        for (Integer id : ids) {
            Genre g = new Genre();
            g.setId(id);
            this.genres.add(g);
        }
    }

    private void addMethod(TVMethod method) {
        this.methods.add(method);
    }

    @Override
    public boolean hasMethod(TVMethod method) {
        return this.methods.contains(method);
    }

    @JsonSetter(value="alternative_titles")
    public void setAlternativeTitles(WrapperGenericList<AlternativeTitle> alternativeTitles) {
        this.alternativeTitles = alternativeTitles.getResults();
        this.addMethod(TVMethod.ALTERNATIVE_TITLES);
    }

    @JsonSetter(value="changes")
    public void setChanges(WrapperChanges changes) {
        this.changes = changes.getChangedItems();
        this.addMethod(TVMethod.CHANGES);
    }

    @JsonSetter(value="content_ratings")
    public void setContentRatings(WrapperGenericList<ContentRating> contentRatings) {
        this.contentRatings = contentRatings.getResults();
        this.addMethod(TVMethod.CONTENT_RATINGS);
    }

    @JsonSetter(value="credits")
    public void setCredits(MediaCreditList credits) {
        this.credits = credits;
        this.addMethod(TVMethod.CREDITS);
    }

    @JsonSetter(value="external_ids")
    public void setExternalIDs(ExternalID externalIDs) {
        this.externalIDs = externalIDs;
        this.addMethod(TVMethod.EXTERNAL_IDS);
    }

    @JsonSetter(value="images")
    public void setImages(WrapperImages images) {
        this.images = images.getAll(new ArtworkType[0]);
        this.addMethod(TVMethod.IMAGES);
    }

    @JsonSetter(value="keywords")
    public void setKeywords(WrapperGenericList<Keyword> keywords) {
        this.keywords = keywords.getResults();
        this.addMethod(TVMethod.KEYWORDS);
    }

    @JsonSetter(value="translations")
    public void setTranslations(WrapperTranslations translations) {
        this.translations = translations.getTranslations();
        this.addMethod(TVMethod.TRANSLATIONS);
    }

    @JsonSetter(value="similar")
    public void setSimilarTV(WrapperGenericList<TVInfo> similarTV) {
        this.similarTV = similarTV.getResults();
        this.addMethod(TVMethod.SIMILAR);
    }

    @JsonSetter(value="videos")
    public void setVideos(WrapperGenericList<Video> videos) {
        this.videos = videos.getResults();
        this.addMethod(TVMethod.VIDEOS);
    }

    public List<AlternativeTitle> getAlternativeTitles() {
        return this.alternativeTitles;
    }

    public List<ChangeKeyItem> getChanges() {
        return this.changes;
    }

    public List<ContentRating> getContentRatings() {
        return this.contentRatings;
    }

    public MediaCreditList getCredits() {
        return this.credits;
    }

    public ExternalID getExternalIDs() {
        return this.externalIDs;
    }

    public List<Artwork> getImages() {
        return this.images;
    }

    public List<Keyword> getKeywords() {
        return this.keywords;
    }

    public List<Translation> getTranslations() {
        return this.translations;
    }

    public List<TVInfo> getSimilarTV() {
        return this.similarTV;
    }

    public List<Video> getVideos() {
        return this.videos;
    }
}

